(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    101016,       3024]*)
(*NotebookOutlinePosition[    102585,       3068]*)
(*  CellTagsIndexPosition[    102541,       3064]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Introducci\[OAcute]n a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que sigue es bastante extenso y no es preciso que, en una primera lectura, \
lo leas todo con detalle. En particular, la secci\[OAcute]n dedicada a las \
funciones elementales y la secci\[OAcute]n dedicada a listas contienen muchos \
comandos que ir\[AAcute]s aprendiendo conforme los vayas necesitando. \
Intentar memorizarlos ahora no ser\[IAcute]a buena idea. Es suficiente con \
que sepas de su existencia y compruebes su uso con los ejemplos puestos. Las \
cosas que s\[IAcute] debes aprender son las siguientes.\
\>", "Text"],

Cell[TextData[{
  "Crear y evaluar celdas de ",
  StyleBox["input",
    FontSlant->"Italic"],
  " y de texto. Seleccionar celdas.\nConsultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nRealizar operaciones aritm\[EAcute]ticas y entender bien su orden de \
prelaci\[OAcute]n.\nDistinguir entre valores exactos, es decir, valores simb\
\[OAcute]licos como \[DoubledPi] o ",
  Cell[BoxData[
      \(TraditionalForm\`\@5\)]],
  " y valores aproximados como 3.1416 o 2.236.\nDistinguir entre calcular de \
forma exacta (c\[AAcute]lculo simb\[OAcute]lico ) y calcular de forma \
aproximada (c\[AAcute]lculo num\[EAcute]rico).\nSaber usar los principales \
operadores boleanos. \nDistinguir entre variables y constantes.\nUsar el \
comando Clear[ ] con sus opciones apropiadadas en cada caso.\nDistinguir \
entre el comando de asignaci\[OAcute]n y el comando de asignaci\[OAcute]n \
diferida.\nDefinir funciones. Evaluar correctamente una funci\[OAcute]n.\nLos \
nombres de las funciones elementales m\[AAcute]s usuales en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nGenerar listas con Table[ ] o Range[ ]. \nSeleccionar elementos en una \
lista. Comando Select[ ].\nEvaluar una funci\[OAcute]n en los elementos de \
una lista. Comandos Map[ ] y Apply[ ].\nSumar y multiplicar listas y sumar y \
multiplicar los elementos de una lista. Comandos Plus[ ], Times[ ].\nDefinir \
reglas de sustituci\[OAcute]n y usar el operador de sustituci\[OAcute]n."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "El entorno de trabajo. Distintos tipos de celdas. Evaluaci\[OAcute]n de \
celdas de ",
  StyleBox["input",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  "Acabas de abrir un cuaderno (notebook) de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[". Arriba tienes la barra de men\[UAcute] y a la derecha tienes \
una \"paleta\" cuya utilidad ir\[AAcute]s aprendiendo en lo que sigue. Lo \
primero que vas a hacer es maximizar esta ventana para que puedas leer mejor \
(la paleta se queda escondida detr\[AAcute]s de ella). Observa que este \
cuaderno est\[AAcute] estructurado en ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["celdas",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[". A la derecha de cada celda ver\[AAcute]s uno o varios \
corchetes. El m\[AAcute]s interior de ellos delimita la celda en cuesti\
\[OAcute]n. ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" suele agrupar las celdas en varias categor\[IAcute]as como, por \
ejemplo, pertenecer a la misma secci\[OAcute]n o a la misma \
subsecci\[OAcute]n; y es eso precisamente lo que reflejan los corchetes \
externos. Hay celdas de distintos tipos. Esta que est\[AAcute]s leyendo es \
una celda de texto y si te fijas bien el corchete que la delimita tiene una \
doble barrita arriba. Para escribir en un cuaderno de ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" primero ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["tienes que crear una nueva celda",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" lo que se hace como sigue: situa el rat\[OAcute]n fuera de una \
celda, por ejemplo, en el peque\[NTilde]o espacio que hay entre dos celdas \
consecutivas y cuando el cursor se convierta en una barra horizontal haz clic \
con el bot\[OAcute]n izquierdo del rat\[OAcute]n y aparecer\[AAcute] una l\
\[IAcute]nea horizontal; seguidamente escribe lo que quieras. Cuando acabes \
de escribir se habr\[AAcute] creado una nueva celda cuyo contenido ser\
\[AAcute] lo que t\[UAcute] has escrito. Escribe ahora tu nombre debajo de \
esta celda.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text"],

Cell[TextData[{
  "Como no le has dicho a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que solamente quer\[IAcute]as escribir texto el programa ha creado una \
nueva ",
  StyleBox["celda de entrada",
    FontSlant->"Italic"],
  " (input cell). Observa que, con el estilo que estamos usando en este \
cuaderno, las celdas de entrada tienen un aspecto muy diferente de las celdas \
de texto. Pon el rat\[OAcute]n sobre el corchete interior de la celda que has \
creado con tu nombre y cuando el cursor se convierta en una flecha haz clic \
con el bot\[OAcute]n izquierdo del rat\[OAcute]n. As\[IAcute] es como se \
seleccionan celdas. Ahora, mientras la celda est\[AAcute] seleccionada, pulsa \
Alt+7 para convertirla en una celda de texto (alternativamente, en la barra \
de men\[UAcute] Cell\[Rule]Display As\[Rule]Text). \nLas ",
  StyleBox["celdas de input",
    FontSlant->"Italic"],
  " son las que se crean por defecto y sirven para introducir datos y \
funciones y podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que las ejecute y realice los c\[AAcute]lculos indicados. Para ejecutar \
una celda de",
  StyleBox[" input",
    FontSlant->"Italic"],
  " debes hacer clik con el bot\[OAcute]n izquierdo del rat\[OAcute]n en alg\
\[UAcute]n lugar dentro de la celda. Ver\[AAcute]s un cursor vertical que \
aparece y desaparece. Ahora pulsa la tecla \"Intro\" del teclado \
num\[EAcute]rico o bien pulsa \"may\[UAcute]sculas\" + \"Return\" y comprobar\
\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ejecuta la celda y te da la respuesta correspondiente en una ",
  StyleBox["celda de salida",
    FontSlant->"Italic"],
  ". Ejecuta la siguiente celda."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\( Sin[x]\/x\) 
        \[DifferentialD]x\)], "Input"],

Cell[TextData[{
  "Observa que el programa ha escrito In[1] y Out[1] para referirse a la \
entrada y salida correspondientes. De esta forma ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lleva un control de todo lo que vas haciendo lo que te permite aprovechar \
los resultados obtenidos para otros c\[AAcute]lculos posteriores. \
F\[IAcute]jate en que el corchete que delimita una celda de entrada tiene un \
peque\[NTilde]o triangulito en la parte superior. En esta primera evaluaci\
\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha tenido que cargar el n\[UAcute]cleo (el ",
  StyleBox["kernel",
    FontSlant->"Italic"],
  "), es decir, las reglas e instrucciones internas de c\[AAcute]lculo del \
programa las cuales ya permanecer\[AAcute]n en la memoria hasta que lo \
cierres. Por eso esta primera evaluaci\[OAcute]n es algo m\[AAcute]s lenta de \
lo normal."
}], "Text"],

Cell[TextData[{
  "En una misma celda puedes escribir varias instrucciones en l\[IAcute]neas \
distintas (para pasar de una l\[IAcute]nea a otra se pulsa \"Return\")  y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpreta cada una de ellas como una entrada diferente. La siguiente \
celda de input contiene dos entradas y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " producir\[AAcute] dos salidas, una para cada entrada."
}], "Text"],

Cell[BoxData[{
    \(Limit[\(x - Sin[x]\)\/x\^3, x \[Rule] 0]\), 
    \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\(\( 1 - Cos[x]\)\/x\^2\) 
        \[DifferentialD]x\)}], "Input"],

Cell["\<\
Comprueba que si ahora ejecutas otra celda de entrada no se le asignar\
\[AAcute] In[3] sino In[4].\
\>", "Text"],

Cell[BoxData[
    \(Expand[\((1 + x + x\^2)\)\^7, x]\)], "Input"],

Cell[TextData[{
  "A veces no interesa que se muestre en pantalla el resultado de una \
entrada. Por ejemplo si le pides a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que genere una lista con todos los n\[UAcute]meros del 1 al 100 no te \
interesa para nada que se muestre el resultado en pantalla. Ejecuta la \
siguiente celda."
}], "Text"],

Cell[BoxData[
    \(Range[100]\)], "Input"],

Cell[TextData[{
  "Para evitar esto basta escribir \";\" al final de la entrada. De esta \
forma ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hace y recuerda los c\[AAcute]culos pero no los muestra en pantalla."
}], "Text"],

Cell[BoxData[
    \(\(Range[200]; \)\)], "Input"],

Cell[TextData[{
  "Aparentemente ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ha hecho nada. Pero eso no es as\[IAcute]. Para referirnos a una \
salida en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " podemos hacerlo invocando de forma expl\[IAcute]cita su identificaci\
\[OAcute]n; ",
  StyleBox["\"Out[p]\"",
    FontWeight->"Bold"],
  "se refiere a la salida n\[UAcute]mero \"",
  StyleBox["p",
    FontWeight->"Bold"],
  "\", y tambi\[EAcute]n con el s\[IAcute]mbolo \"",
  StyleBox["%",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["el cual se refiere siempre a la salida inmediata anterior",
    FontWeight->"Bold"],
  ", el s\[IAcute]mbolo \"",
  StyleBox["%%",
    FontWeight->"Bold"],
  "\" se refiere a ",
  StyleBox["la salida pen\[UAcute]ltima",
    FontWeight->"Bold"],
  ", \"",
  StyleBox["%%%",
    FontWeight->"Bold"],
  "\" a la salida antepen\[UAcute]ltima, etc\[EAcute]tera. Comprobemos que, \
efectivamente, la \[UAcute]ltima salida son los primeros doscientos \
n\[UAcute]meros."
}], "Text"],

Cell[BoxData[
    \(%\)], "Input"],

Cell[TextData[{
  "Para seleccionar una celda se pone el cursor sobre el corchete que la \
delimita y cuando el cursor se convierta en una flechita haces clic con el \
rat\[OAcute]n. Muchos errores e ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se deben a efectos derivados de \"copiar y pegar\". ",
  StyleBox["Para copiar en ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " NO se selecciona texto sino que se selecciona la celda entera se copia y \
se pega y, si es necesario, despu\[EAcute]s se borra lo que sobre.",
    FontWeight->"Bold"]
}], "Text"],

Cell["\<\
Antes de acabar esta primera secci\[OAcute]n, te propongo que selecciones con \
el rat\[OAcute]n el corchete exterior de la derecha y hagas doble clic. Ver\
\[AAcute]s c\[OAcute]mo las celdas de esta secci\[OAcute]n quedan todas \
agrupadas en una sola vi\[EAcute]ndose solamente el encabezado de la secci\
\[OAcute]n. Para abrirlas de nuevo selecciona el corchete con forma de flecha \
que las agrupa y haz doble clic en \[EAcute]l.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones aritm\[EAcute]ticas", "Section"],

Cell[TextData[{
  "Puedes realizar operaciones aritm\[EAcute]ticas con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " igual que con una calculadora manual. Los s\[IAcute]mbolos para estas \
operaciones son los usuales  (\"+\", \"-\", \"*\", \"/\", y \"^\") y se \
realizan con la precedencia usual: la exponenciaci\[OAcute]n (\"^\") precede \
a la multiplicaci\[OAcute]n (\"*\") y a la divisi\[OAcute]n (\"/\") las \
cuales tienen igual precedencia y, a su vez, preceden a la suma y a la \
diferencia que tienen igual precedencia. En una expresi\[OAcute]n como \
\"6*7^5+26\" se calcula primero \"7^5\" seguido por \"6*7^5\" para terminar \
sumando \"26\"."
}], "Text"],

Cell[BoxData[
    \(6*7^5 + 26\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " permite que sustituyas el s\[IAcute]mbolo de la multiplicaci\[OAcute]n \
por un espacio en blanco."
}], "Text"],

Cell[BoxData[
    \(6\ 7^5 + 26\)], "Input"],

Cell["\<\
Ahora que est\[AAcute]s empezando es preferible que uses el s\[IAcute]mbolo \
de la multiplicaci\[OAcute]n para evitar posibles errores. \
\>", "Text"],

Cell[TextData[{
  "A diferencia de las calculadoras manuales m\[AAcute]s sencillas, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede trabajar con fracciones en forma simb\[OAcute]lica, es decir, sin \
convertirlas a su expresi\[OAcute]n decimal."
}], "Text"],

Cell[BoxData[
    \(7 + 9\/13\)], "Input"],

Cell[BoxData[
    \(8\/11 + 6\/7\)], "Input"],

Cell["\<\
Las fracciones se representan siempre en su forma irreducible.\
\>", "Text"],

Cell[BoxData[
    \(4032\/15015\)], "Input"],

Cell[TextData[{
  "Naturalmente, la potencia de c\[AAcute]lculo de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy superior a la de una calculadora manual."
}], "Text"],

Cell[BoxData[
    \(3^95\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Valores exactos y aproximados", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hay dos clases de valores: exactos y aproximados. Valores exactos son los \
enteros, las fracciones y las representaciones simb\[OAcute]licas de \
constantes como \[Pi] o ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  ". De ellos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe calcular tantos d\[IAcute]gitos como sea necesario en cualquier c\
\[AAcute]lculo. Los valores aproximados son los n\[UAcute]meros decimales, es \
decir, n\[UAcute]meros en cuya expresi\[OAcute]n aparece un punto decimal. "
}], "Text"],

Cell[TextData[{
  "Debes tener siempre presente que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " devuelve los resultados de la misma forma que introduces los datos, es \
decir, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nunca tratar\[AAcute] de convertir valores exactos en valores aproximados \
y si en un c\[AAcute]lculo intervienen valores exactos y aproximados el \
resultado ser\[AAcute] un valor aproximado."
}], "Text"],

Cell[BoxData[
    \(4^\((1/2)\) + Log[\[ExponentialE]]\)], "Input"],

Cell[TextData[{
  "En este caso como la operaci\[OAcute]n puede realizarse de forma exacta, \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la hace y presenta el resultado exacto obtenido."
}], "Text"],

Cell[BoxData[
    \(3^\((1/2)\) + Log[5]\)], "Input"],

Cell[TextData[{
  "En este c\[AAcute]lculo como el resultado no es un n\[UAcute]mero exacto \
pero los datos s\[IAcute] lo son, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja de forma simb\[OAcute]lica, no realiza la operaci\[OAcute]n \
indicada y devuelve los mismos datos. Observa lo que ocurre si ahora \
cambiamos el valor exacto \"5\" por \"5.\" que es un n\[UAcute]mero con punto \
decimal y por tanto es considerado por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como un valor aproximado."
}], "Text"],

Cell[BoxData[
    \(3^\((1/2)\) + Log[5. ]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " realiza las operaciones indicadas y el resultado tambi\[EAcute]n es un \
valor aproximado. Pobre resultado pensar\[AAcute]s: s\[OAcute]lo cinco \
decimales, cualquier calculadora manual es m\[AAcute]s precisa. No te \
precipites. Aunque ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "por defecto presenta en pantalla los valores aproximados con solamente ",
  StyleBox["seis d\[IAcute]gitos",
    FontSlant->"Italic"],
  " y a veces los redondea como hizo antes; los n\[UAcute]meros con punto \
decimal son guardados en la memoria interna de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con al menos 16 d\[IAcute]gitos significativos. El comando ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(ImputForm[numero]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " sirve para que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " presente en pantalla todos los d\[IAcute]gitos que conoce de un \
n\[UAcute]mero. "
}], "Text"],

Cell[BoxData[
    \(\(InputForm[3^\((1/2)\) + Log[5. ]]\ \)\)], "Input"],

Cell[TextData[{
  "Lo anterior te indica que ",
  StyleBox["es importante la forma en que introducimos los datos",
    FontWeight->"Bold"],
  ": no es lo mismo introducir 1/2 que .5. Tampoco es lo mismo 2. (un n\
\[UAcute]mero real aproximado para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que 2 sin punto decimal (que es tratado como un n\[UAcute]mero entero). \
Como ya te he dicho antes, cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja con valores exactos lo hace de forma simb\[OAcute]lica y el \
resultado ser\[AAcute] tambi\[EAcute]n un valor exacto. \n",
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  " puede trabajar con n\[UAcute]meros aproximados de cualquier cantidad de d\
\[IAcute]gitos. La ",
  StyleBox["precisi\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["de un n\[UAcute]mero real aproximado es el n\[UAcute]mero de d\
\[IAcute]gitos (en base 10) de dicho n\[UAcute]mero que son considerados como \
significativos para los c\[AAcute]lculos",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue dos clases de n\[UAcute]meros reales aproximados: \
n\[UAcute]meros de precisi\[OAcute]n arbitraria y \
\"n\[UAcute]meros-m\[AAcute]quina\" con precisi\[OAcute]n de m\[AAcute]quina. \
Los n\[UAcute]meros de precisi\[OAcute]n arbitraria pueden tener una cantidad \
arbitraria de d\[IAcute]gitos y su precisi\[OAcute]n se ajusta a medida que \
se hacen c\[AAcute]lculos con ellos. Los n\[UAcute]meros m\[AAcute]quina \
tienen un n\[UAcute]mero fijo de d\[IAcute]gitos significativos para los c\
\[AAcute]lculos y su precisi\[OAcute]n es siempre la misma. Dicha precisi\
\[OAcute]n, con la que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja por defecto, depende del hardware de punto flotante que se \
utilice y su valor es el de la variable global  ",
  StyleBox["$MachinePrecision",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \($MachinePrecision\)], "Input"],

Cell[TextData[{
  " Un valor frecuente de dicha variable es 16. ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox[
  "considera que los n\[UAcute]meros aproximados que se especifican con un n\
\[UAcute]mero de d\[IAcute]gitos menor o igual que 16 son n\[UAcute]meros-m\
\[AAcute]quina y, por tanto, su precisi\[OAcute]n es igual a 16.",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[{
    \(Precision[1.33]\), 
    \(1. /7\), 
    \(Precision[1. /7]\), 
    \(InputForm[1. /7]\)}], "Input"],

Cell[TextData[{
  "Los valores exactos tienen precisi\[OAcute]n infinita y pueden convertirse \
en n\[UAcute]meros aproximados con la precisi\[OAcute]n que queramos. El \
comando \"",
  StyleBox["N[expr, n]",
    FontWeight->"Bold"],
  "\" donde \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" es un valor exacto y ",
  StyleBox["n>16",
    FontWeight->"Bold"],
  ", eval\[UAcute]a \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" num\[EAcute]ricamente convirti\[EAcute]ndola en un n\[UAcute]mero \
aproximado con ",
  StyleBox["n",
    FontWeight->"Bold"],
  " d\[IAcute]gitos de precisi\[OAcute]n, mientras que ",
  StyleBox["N[expr,n]",
    FontWeight->"Bold"],
  " para ",
  StyleBox["n\[LessEqual]16",
    FontWeight->"Bold"],
  " eval\[UAcute]a \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" convirti\[EAcute]ndola en un n\[UAcute]mero-m\[AAcute]quina con \
precision 16. ",
  StyleBox["No",
    FontWeight->"Bold"],
  StyleBox[" es posible aumentar la precisi\[OAcute]n de un n\[UAcute]mero \
aproximado con el comando",
    FontWeight->"Bold"],
  " \"",
  StyleBox["N[expr, n]",
    FontWeight->"Bold"],
  "\"."
}], "Text"],

Cell[BoxData[{
    \(Precision[\@2]\ \  (*
      Un\ n\[UAcute]mero\ exacto\ tiene\ precisi\[OAcute]n\ infinita*) \), 
    \(Precision[N[\@2, 30]]\  (*
      Podemos\ convertirlo\ en\ un\ n\[UAcute]mero\ de\ la\ precisi\[OAcute]n
        \ que\ queramos*) \ \), 
    \(N[\@2, 30]\  (*
      Mathematica\ muestra\ en\ pantalla\ el\ valor\ num\[EAcute]rico\ de\ 
        \@2\ con\ 30\ d\[IAcute]gitos*) \n\), 
    \(Precision[\@2. ]\  (*
      Un\ n\[UAcute]mero\ m\[AAcute]quina\ tiene\ precisi\[OAcute]n\ 16*) 
      \), 
    \(Precision[N[\@2. , 50]]\  (*
      No\ podemos\ aumentar\ su\ precisi\[OAcute]n*) \), 
    \(N[\@2. , 50]\  (*
      Mathematica\ muestra\ en\ pantalla\ 16\ d\[IAcute]gitos*) \n\), 
    \(N[\@2, 3]\  (*
      Mathematica\ muestra\ en\ pantalla\ el\ valor\ num\[EAcute]rico\ de\ 
        \@2\ con\ 3\ d\[IAcute]gitos*) \), 
    \(Precision[N[\@2, 3]]\  (*
      \([N[\@2, 3] es\ un\ n\[UAcute]mero\ m\[AAcute]quina\ con\ 
          precisi\[OAcute]n\ 16\)*) \), 
    \(InputForm[N[\@2, 3]]\n (*
      La\ forma\ en\ que\ Mathematica\ lo\ representa\ internamente\ con\ 16\ 
          d\[IAcute]gitos . \ El\ mismo\ resultado\ se\ obtiene\ para\ 
          N[\@2, k]\ con\n\t\t\t\ k \[LessEqual] 16*) \)}], "Input"],

Cell["\<\
En la celda anterior hemos escrito varios comentarios. Los comentarios son \
imprescindibles para explicar lo que hacen los comandos que defines al \
escribir un programa. Un comentario es de la forma \"(*aqu\[IAcute] se \
escribe el texto del comentario*)\" y son ignorados por el programa cuando se \
ejecutan las celdas que los contienen.\
\>", "Text"],

Cell[TextData[{
  "Cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja con valores exactos se dice que lo hace con \"precisi\[OAcute]n \
infinita\". Ya puedes suponer que trabajar simb\[OAcute]licamente con valores \
exactos requiere m\[AAcute]s memoria y m\[AAcute]s tiempo de c\[AAcute]lculo \
que trabajar con valores aproximados, por eso ",
  StyleBox[
  "cuando escribas programas que deban realizar muchos c\[AAcute]lculos es \
muy importante que te asegures de que ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" trabajar\[AAcute] con valores aproximados",
    FontWeight->"Bold"],
  " (controlando, si es necesario, la precisi\[OAcute]n con la que trabaja)."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones boleanas", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tienen algunas funciones que no devuelven un resultado num\[EAcute]rico \
sino un valor \"False\" o \"True\". Entre ellas se encuentran: \nA) \
Operadores relacionales de comparaci\[OAcute]n de dos expresiones aritm\
\[EAcute]ticas: menor (<), mayor (>), menor o igual (<=), mayor o igual (>=), \
igual (==) \[DownExclamation]con dos signos de igualdad!, distinto (!=). \nB) \
Operadores l\[OAcute]gicos que trabajan con valores \"False\" y \"True\" y \
devuelven como valor \"False\" o \"True\". Entre estos operadores \
est\[AAcute]n: el operador \"and\" (&&) (conjunci\[OAcute]n l\[OAcute]gica \
que devuelve \"True\" si los dos valores sobre los que act\[UAcute]a son \
\"True\" y devuelve \"False\" en otro caso), el oerador \"or\" ( | | ) \
(disyunci\[OAcute]n l\[OAcute]gica que devuelve \"True\" si algunos de los \
valores sobre los que act\[UAcute]a es \"True\" y devuelve \"False\" si ambos \
son \"False\").\nTecleando \"\[EscapeKey] <= \[EscapeKey]\" obtienes \
\[LessEqual], tecleando \"\[EscapeKey] >= \[EscapeKey]\" obtienes \
\[GreaterEqual], tecleando \"\[EscapeKey] && \[EscapeKey]\" obtienes \[And], \
tecleando \"\[EscapeKey] || \[EscapeKey]\" obtienes \[Or], tecleando \"\
\[EscapeKey] != \[EscapeKey]\" obtienes \[NotEqual].\nAqu\[IAcute] tienes \
algunos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(5 > 5\), 
    \(8 \[GreaterEqual] 8\), 
    \(\((5 > 7)\) || \((3 < 4)\)\), 
    \(\((5 > 7)\) && \((3 > 4)\)\), 
    \(\@2 < 27/22\)}], "Input"],

Cell[TextData[{
  "Cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no puede dicidir una respuesta devuelve sin comentarios la misma expresi\
\[OAcute]n de entrada."
}], "Text"],

Cell[BoxData[
    \(\(x < 27\  (*
      como\ x\ no\ tiene\ asignado\ ning\[UAcute]n\ valor\ num\[EAcute]rico\ 
        Mathematica\ no\ puede\ hacer\ la\ comparaci\[OAcute]n\ que\ 
        pedimos*) \)\)], "Input"],

Cell[TextData[{
  "El operador de igualdad (==) puede utilizarse para comprobar si dos \
cantidades num\[EAcute]ricas \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" y \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" son \"iguales\". Si las cantidades son aproximadas el operador de \
igualdad (==) ",
  StyleBox["comprueba si ambas son iguales con la precisi\[OAcute]n de \
aquella que la tiene menor",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n debes de tener en cuenta que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " asocia a cada n\[UAcute]mero aproximado ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " una cota de error \[Delta] (relacionada con el n\[UAcute]mero de cifras \
decimales de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " y con el valor absoluto de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ") y considera que el valor verdadero de dicho n\[UAcute]mero puede ser \
cualquier n\[UAcute]mero en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`x - \[Delta]/2, x + \[Delta]/2\)]],
  "[. Por ello ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " considera iguales a ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " todos los n\[UAcute]meros en dicho intervalo. Por esta raz\[OAcute]n el \
operador de igualdad puede proporcionar algunas veces respuestas extra\
\[NTilde]as. No es este el momento para entrar en detalles, solamente quiero \
llamarte la atenci\[OAcute]n para que seas prudente en el uso del operador de \
igualdad (==) cuando quieras usarlo para saber cu\[AAcute]ndo dos cantidades \
pueden ser consideradas iguales a efectos de c\[AAcute]lculo. Cuando el \
operador de igualdad \"",
  StyleBox["cantidad1==cantidad2\"",
    FontWeight->"Bold"],
  " proporciona la salida True, debes interpretar que dichas cantidades son \
iguales con una cierta cota de error. No es propio de la asignatura de An\
\[AAcute]lisis Matem\[AAcute]tico profundizar en estos temas. En otras \
asignaturas estudiar\[AAcute]s la aritm\[EAcute]tica de punto flotante, la \
forma en que se representan internamente los n\[UAcute]meros en un ordenador, \
la propagaci\[OAcute]n de errores de redondeo y otros temas afines y entonces \
entender\[AAcute]s estos comportamientos (que no son, por supuesto, espec\
\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Aqu\[IAcute] tienes algunos ejemplos de lo que digo."
}], "Text"],

Cell[BoxData[
    \(\(123456789012345.  == 123456789012344\  (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        iguales . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 1\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(1.2345678901234 == 1.2345678901233\  (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        distintos . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 
        10^\(-13\)\ \ *) \)\)], "Input"],

Cell[BoxData[
    \(\(1.23456789012349 == 1.23456789012348 (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        iguales . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 
        10^\(-14\)\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(1 == 1.  + 10^\(-14\)\ \  (*
      Aqu\[IAcute]\ trabajamos\ con\ precisi\[OAcute]n\ 16\ y\ Mathematica\ 
        considera\ que\ dichas\ cantidades\ son\ iguales\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(1 == N[1 + 10^\(-14\), 17]\ \  (*
      Aqu\[IAcute]\ trabajamos\ con\ precisi\[OAcute]n\ 17\ y\ Mathematica\ 
        considera\ que\ dichas\ cantidades\ no\ son\ iguales\ *) \ \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Pi == N[Pi, 2]\  (*
      Comprueba\ si\ son\ iguales\ consider\[AAcute]ndolos\ como\ 
        n\[UAcute]meros\ m\[AAcute]quina\ *) \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Consultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[TextData[{
  "Consultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es lo m\[AAcute]s f\[AAcute]cil que te puedas imaginar. Basta pulsar F1. \
Si antes has seleccionado con el rat\[OAcute]n la palabra que quieres \
consultar, la ayuda se abrir\[AAcute] justamente donde te interesa. \
Selecciona la palabra en la celda siguiente y pulsa F1. "
}], "Text"],

Cell["Integrate", "Text",
  TextAlignment->Center],

Cell["\<\
Tambi\[EAcute]n puedes consultar sobre un s\[IAcute]mbolo o un comando espec\
\[IAcute]ficos escribiendo uno o dos s\[IAcute]mbolos de \
interrogaci\[OAcute]n seguido del nombre del comando del que quieres \
informaci\[OAcute]n.Ejecuta la siguiente celda.\
\>", "Text"],

Cell[BoxData[
    \(\(?\ N\)\)], "Input"],

Cell["Si todav\[IAcute]a quieres m\[AAcute]s informaci\[OAcute]n hazlo como \
sigue.", "Text"],

Cell[BoxData[
    \(?? \ N\)], "Input"],

Cell["\<\
Para preguntar por todos los s\[IAcute]mbolos que empiezan por W puedes \
hacerlo como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(?\ W*\)\)], "Input"],

Cell["\<\
Para preguntar por todos los s\[IAcute]mbolos que contienen Pre puedes \
hacerlo como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(?*Pre*\)\)], "Input"],

Cell[TextData[{
  StyleBox["Debes tener en cuenta que",
    FontWeight->"Bold"],
  " ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["distingue entre may\[UAcute]sculas y min\[UAcute]sculas",
    FontWeight->"Bold"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Escribir expresiones matem\[AAcute]ticas en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[TextData[{
  "Frecuentemente las expresiones matem\[AAcute]ticas se pueden escribir de \
varias formas que solamente se diferencian por su apariencia \
tipogr\[AAcute]fica. Puedes escribir 3^(1/7) o ",
  Cell[BoxData[
      \(TraditionalForm\`\@3\%7\)]],
  " a efectos de c\[AAcute]lculo son exactamente igual. Las paletas te ayudan \
a escribir con la apariencia que prefieras y son muy f\[AAcute]ciles de usar. \
En File\[Rule]Palettes encontrar\[AAcute]s varias paletas adem\[AAcute]s de \
la b\[AAcute]sica (BasicInput) que se abre al iniciar el programa. Tambi\
\[EAcute]n puedes consultar Edit\[Rule]Expression Input.Te indico a \
continuaci\[OAcute]n otra forma de escribir algunos s\[IAcute]mbolos de uso \
frecuente.\nPotencias: usa \"\[ControlKey]+6\". Por ejemplo: a \
\"\[ControlKey]+6\" b = ",
  Cell[BoxData[
      \(TraditionalForm\`a\^b\)]],
  " (para salir de la celda \"inline\" que se crea hay que pulsar \
\[ControlKey]+espacio) \nRa\[IAcute]ces: usa \"\[ControlKey]+2\". Por \
ejemplo: \"\[ControlKey]+2\" a = ",
  Cell[BoxData[
      \(TraditionalForm\`\@a\)]],
  " (para salir de la celda \"inline\" que se crea hay que pulsar \
\[ControlKey]+espacio) \nLetras griegas: usa \[EscapeKey]+letra latina \
equivalente+\[EscapeKey]. Por ejemplo: \[EscapeKey]+p+\[EscapeKey] = \[Pi].\n\
La letra E est\[AAcute] reservada en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para el n\[UAcute]mero base de los logaritmos naturales. Puedes \
escribirlo tambi\[EAcute]n con \[EscapeKey]+ee+\[EscapeKey] = \
\[ExponentialE].\nEl n\[UAcute]mero \[Pi] puedes escribirlo tambi\[EAcute]n \
Pi. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Variables y constantes. El comando de asignaci\[OAcute]n (",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  ")"
}], "Section"],

Cell[TextData[{
  "Lo que realmente distingue a un programa como ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es su capacidad para trabajar simb\[OAcute]licamente; es decir, trabajar \
con expresiones algebraicas en las que intervienen s\[IAcute]mbolos que no \
tienen un valor num\[EAcute]rico concreto. Solemos referirnos a estos s\
\[IAcute]mbolos como ",
  StyleBox["variables",
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[BoxData[{
    \(a^\((1/2)\) a^\((1/3)\)\), 
    \(a\  + \ 3  b\  + \ c^2\  + 4\ a\  + \ 3\ c^2\), 
    \(Exp[x] Exp[y]\)}], "Input"],

Cell[TextData[{
  "Para multiplicar n\[UAcute]meros por variables no es preciso dejar un \
espacio en blanco. Para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pr\[AAcute]cticamente cualquier letra o combinaci\[OAcute]n de letras \
puede ser una variable. Hay excepciones que corresponden a algunos \
s\[IAcute]mbolos protegidos como los de las operaciones aritm\[EAcute]ticas o \
como la letra E, que siempre indica el n\[UAcute]mero \[ExponentialE] base de \
los logaritmos naturales. Sin embargo, todas las letras min\[UAcute]sculas \
{x, y, z... a, b, c, d...} y sus combinaciones pueden usarse sin problemas \
para representar variables. No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue entre may\[UAcute]sculas y min\[UAcute]sculas. "
}], "Text"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el s\[IAcute]mbolo de igualdad (=) es la forma usual de escribir el \
comando \"",
  StyleBox["Set[ ]",
    FontWeight->"Bold"],
  "\" (l\[EAcute]ase ",
  StyleBox["atribuye",
    FontSlant->"Italic"],
  " o ",
  StyleBox["asigna",
    FontSlant->"Italic"],
  "). As\[IAcute] \"",
  StyleBox["expr1=expr2",
    FontWeight->"Bold"],
  "\" y \"",
  StyleBox["Set[expr1,expr2]",
    FontWeight->"Bold"],
  "\" son dos formas de decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que eval\[UAcute]e ",
  StyleBox["inmediatamente",
    FontSlant->"Italic"],
  " ",
  StyleBox["expr2",
    FontWeight->"Bold"],
  " y el resultado de esta operaci\[OAcute]n lo asigne en adelante al s\
\[IAcute]mbolo ",
  StyleBox["expr1",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "interpreta que una expresi\[OAcute]n \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" formada por una letra o una combinaci\[OAcute]n de letras es una \
variable si no se le ha asignado ning\[UAcute]n valor concreto; cuando a \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" se le asigna un valor concreto, el programa reemplazar\[AAcute] cada \
aparici\[OAcute]n de \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" por el valor que le hemos asignado; es decir, tratar\[AAcute] \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" como una ",
  StyleBox["constante",
    FontWeight->"Bold"],
  ". Cuando asignes valores a expresiones es muy conveniente que las \
expresiones que utilices contengan solamente letras min\[UAcute]sculas. \
Puedes usar como s\[IAcute]mbolo para una expresi\[OAcute]n \
pr\[AAcute]cticamente cualquier combinaci\[OAcute]n de letras y \
n\[UAcute]meros. Aqu\[IAcute] asigno el valor 5 al s\[IAcute]mbolo \"a\" y el \
valor 7 al s\[IAcute]mbolo \"ab\"."
}], "Text"],

Cell[BoxData[{
    \(a = 5\), 
    \(ab = 7\)}], "Input"],

Cell["\<\
Ahora todas las apariciones de \"a\" quedan sustituidas por 5 y las de \"ab\" \
por 7.\
\>", "Text"],

Cell[BoxData[
    \(a*ab\)], "Input"],

Cell["\<\
Podemos asignar ahora otro valor para \"a\" y al hacerlo se elimina el valor \
anterior.\
\>", "Text"],

Cell[BoxData[{
    \(a = 10\), 
    \(a*ab\)}], "Input"],

Cell[TextData[{
  "Podemos preguntarle a ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "p",
  "ara saber el significado actual de un s\[IAcute]mbolo."
}], "Text"],

Cell[BoxData[
    \(\(?\ a\ \ \)\)], "Input"],

Cell[BoxData[
    \(\(?\ ab\)\)], "Input"],

Cell[TextData[{
  "Para quitar el valor asignado a una expresi\[OAcute]n usamos la orden \"",
  StyleBox["Clear[exp]",
    FontWeight->"Bold"],
  "\". "
}], "Text"],

Cell[BoxData[
    \(\(Clear[a]\  (*
      quita\ cualquier\ valor\ asignado\ al\ s\[IAcute]mbolo\ a\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(a + ab\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "El comando de asignaci\[OAcute]n diferida (",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  ")"
}], "Section"],

Cell[TextData[{
  "Es importante distinguir entre el comando de asignaci\[OAcute]n inmediata \
(=) y el comando de asignaci\[OAcute]n diferida (:=) cuyo nombre es \"",
  StyleBox["SetDelayed[ ]",
    FontWeight->"Bold"],
  "\". Cuando escribimos \"",
  StyleBox["expr1 ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` := \)],
    FontWeight->"Bold"],
  StyleBox[" expr2\"",
    FontWeight->"Bold"],
  " ",
  StyleBox["le estamos diciendo a", "TI",
    FontSlant->"Plain"],
  StyleBox[" ", "TI"],
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  " que asigne \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" al valor diferido de \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" pero \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["no se eval\[UAcute]a inmediatamente sino que para ello hay que \
llamar a",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["y cada vez que lo hacemos",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["se eval\[UAcute]a de nuevo",
    FontSlant->"Italic"],
  ". Para que entiendas bien la diferencia, en el siguiente ejemplo uso el \
comando \"",
  StyleBox["Random[ ]",
    FontWeight->"Bold"],
  "\" que proporciona un n\[UAcute]mero aleatorio entre 0 y 1. Cada vez que \
ejecutas el comando obtienes (salvo rara casualidad) un n\[UAcute]mero \
distinto. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(Random[]\), 
    \(Random[]\), 
    \(Random[]\)}], "Input"],

Cell["\<\
Asignamos ahora el s\[IAcute]mbolo \"aleatorio1\" a una ejecuci\[OAcute]n \
inmediata del comando Random[ ]. Dicho comando se ejecutar\[AAcute] y el \
resultado obtenido ser\[AAcute] en adelante el valor de \"aleatorio1\".\
\>", "Text"],

Cell[BoxData[
    \(aleatorio1 = Random[]\)], "Input"],

Cell[BoxData[
    \(aleatorio1\)], "Input"],

Cell["\<\
Hacemos ahora una asignaci\[OAcute]n diferida del s\[IAcute]mbolo \
\"aleatorio2\" al comando Random[ ]. El comando Random[ ] no ser\[AAcute] \
evaluado. Para evaluarlo deberemos invocar al s\[IAcute]mbolo \"aleatorio2\" \
y cada vez que lo hagamos se ejecutar\[AAcute] de nuevo dicho comando por lo \
que el valor de \"aleatorio2\" ser\[AAcute] diferente cada vez que lo \
llamemos.\
\>", "Text"],

Cell[BoxData[
    \(aleatorio2 := Random[]\)], "Input"],

Cell[BoxData[{
    \(aleatorio2\), 
    \(aleatorio2\)}], "Input"],

Cell[TextData[{
  "Habr\[AAcute]s observado que cuando se usa el comando de \
asignaci\[OAcute]n diferida ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no presenta ninguna salida en pantalla. Eso es debido a que dicho \
comando, al igual que otros, tiene salida Null  que es un s\[IAcute]mbolo \
usado por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para indicar la ausencia de una expresi\[OAcute]n o resultado como salida \
en pantalla. Cuando un comando tiene salida Null no se imprime nada en \
pantalla."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones", "Section"],

Cell[TextData[{
  "En la mayor\[IAcute]a de los lenguajes de programaci\[OAcute]n para \
definir una funci\[OAcute]n es necesario declarar previamente las variables y \
el tipo de variables. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy f\[AAcute]cil definir funciones. No es preciso declarar las \
variables ni el tipo de variable. Todo lo que tienes que hacer es definir la \
funci\[OAcute]n de la forma que voy a explicarte. Lo primero que tienes que \
tener en cuenta es que ",
  StyleBox["las variables de las funciones (que suelen llamarse ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["argumentos",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[
  " de la funci\[OAcute]n) van entre corchetes [ ] NUNCA entre \
par\[EAcute]ntesis ( )",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ". ",
  StyleBox[
  "Los par\[EAcute]ntesis ( ) solamente se usan para indicar, cuando es \
necesario, el orden en que debe evaluarse una expresi\[OAcute]n",
    FontWeight->"Bold"],
  ". Intentemos ya,  sin tomar m\[AAcute]s precauciones, definir una funci\
\[OAcute]n."
}], "Text"],

Cell[BoxData[
    RowBox[{\(f[x] = x^2\), " ", 
      RowBox[{"(*", 
        StyleBox[
          \(recuerda : \ 
            las\ variables\ de\ una\ funci\[OAcute]n\ van\ siempre\ entre\ 
              corchetes\),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}]}]], "Input"],

Cell["\<\
Si lo que acabamos de definir es una funci\[OAcute]n debe ser posible \
calcular su valor para distintos valores de la variable. Veamos si esto es as\
\[IAcute].\
\>", "Text"],

Cell[BoxData[{
    \(f[2]\), 
    \(f[y]\), 
    \(f[x]\)}], "Input"],

Cell[TextData[{
  "Ya ves que lo que hemos definido no es una funci\[OAcute]n. Lo que hemos \
hecho ha sido, simplemente, asignar el s\[IAcute]mbolo f[x] a x^2. \
F\[IAcute]jate en que para definir una funci\[OAcute]n las variables deben \
ser independientes de los s\[IAcute]mbolos con que las representemos. La \
funci\[OAcute]n que queremos definir es una regla que a \"algo\" le asigna \
\"algo^2\". Pero ese \"algo\" no puede identificarse con nada concreto porque \
unas veces puede ser un n\[UAcute]mero y otras veces puede ser una expresi\
\[OAcute]n algebraica o de otro tipo. Lo que necesitamos es proporcionarle a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " un ",
  StyleBox["patr\[OAcute]n o modelo",
    FontWeight->"Bold"],
  " (",
  StyleBox["pattern",
    FontSlant->"Italic"],
  " en ingl\[EAcute]s) que pueda ser reemplazado de muy diversas formas. Esto \
se hace en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con el operador \"",
  StyleBox["Blank[ ]",
    FontWeight->"Bold"],
  "\" que se escribe _ (may\[UAcute]sculas+gui\[OAcute]n). "
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = x^2\  (*
      Mathematica\ interpreta\ esto\ como\ f[algo] = algo^2\ *) \)}], "Input"],

Cell[BoxData[{
    \(f[2]\), 
    \(f[y]\), 
    \(f[x]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpreta ",
  StyleBox["x_",
    FontWeight->"Bold"],
  " como un comod\[IAcute]n que puede ser reemplazado por cualquier expresi\
\[OAcute]n simple."
}], "Text"],

Cell[BoxData[{
    \(f[x + y + 2  x*z]\), 
    \(f[\@x]\)}], "Input"],

Cell["\<\
La misma regla sirve para definir funciones de m\[AAcute]s de una variable. \
Aqu\[IAcute] tienes algunos ejemplos.\
\>", "Text"],

Cell[BoxData[{
    \(g[x_, y_] = \@\(x^2 + \(y^2\ \)\) (*
      Mathematica\ interpreta\ esto\ como\ g[algo, otroalgo] = 
        \@\(algo^2 + otroalgo^2\)*) \), 
    \(g[1, 2]\), 
    \(g[u + v, s + t]\), 
    \(Clear[f, g]\)}], "Input"],

Cell["\<\
Para definir una funci\[OAcute]n puedes usar la asignaci\[OAcute]n inmediata \
como hemos hecho antes y tambi\[EAcute]n la asignaci\[OAcute]n diferida. \
Muchas veces no tiene mayor importancia cu\[AAcute]l de las dos uses pero a \
veces s\[IAcute] que la tiene. Observa.\
\>", "Text"],

Cell[BoxData[{
    \(f[x_] = N[x, 30]\  (*
      aproximaci\[OAcute]n\ decimal\ de\ x\ con\ 30\ d\[IAcute]gitos\ 
        significativos*) \), 
    \(f[Pi]\)}], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro lo que ha pasado. Al definir f[x] con la asignaci\
\[OAcute]n inmediata se eval\[UAcute]a enseguida el comando N[x,30] y, como x \
no es una cantidad num\[EAcute]rica, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " da como respuesta el propio x que es lo que de aqu\[IAcute] en adelante \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpretar\[AAcute] como f[\"deloquesea\"]."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := N[x, 30]\), 
    \(f[Pi]\)}], "Input"],

Cell["\<\
Ahora hemos definido f[x] con la asignaci\[OAcute]n diferida por lo que el \
comando N[x,30] no se eval\[UAcute]a hasta que se llama a la funci\[OAcute]n. \
\
\>", "Text"],

Cell["\<\
Como estrategia general es conveniente usar la asignaci\[OAcute]n diferida \
para definir funciones pero hay algunos casos importantes (por ejemplo, para \
definir derivadas) en los que es preferible usar la asignaci\[OAcute]n \
directa.\
\>", "Text"],

Cell[TextData[{
  "No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue entre may\[UAcute]sculas y min\[UAcute]sculas. Todos los \
comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " empiezan con una letra may\[UAcute]scula, por eso ",
  StyleBox["una buena estrategia para representar tus propios comandos y \
funciones es usar letras min\[UAcute]sculas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". La orden \"",
  StyleBox["Clear[\"@\"]",
    FontWeight->"Bold"],
  "\" elimina todas las constantes y funciones que hayamos representado con \
letras ",
  StyleBox["min\[UAcute]sculas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Si queremos eliminar todas las constantes y funciones que hemos definido \
usaremos ",
  StyleBox["Clear[\"Global`*\"]",
    FontWeight->"Bold"],
  "  (el acento que hay que usar es el que est\[AAcute] a la derecha de la \
p). "
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(Clear["\<Global`*\>"]\)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones condicionadas", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a ver c\[OAcute]mo se pueden definir \
funciones a trozos y c\[OAcute]mo podemos imponer que una funci\[OAcute]n \
determinada trabaje solamente con cierto tipo de datos. El operador ",
  StyleBox["Condition",
    FontWeight->"Bold"],
  "  ( ",
  StyleBox["/;",
    FontWeight->"Bold"],
  " ) tiene distintos usos; el que nos interesa ahora es de la forma \"",
  StyleBox["expr1:=expr2 /; test",
    FontWeight->"Bold"],
  "\" que representa una definici\[OAcute]n que debe aplicarse solamente si \
\"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" da \"True\". Aqu\[IAcute] es indispensable usar la asignaci\[OAcute]n \
diferida porque en otro caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata de comprobar inmediatamente \"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" con valores simb\[OAcute]licos lo que produce un error. Aqu\[IAcute] \
tienes un ejemplo."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := 2 - x\  /; x < 0\), 
    \(f[x_] := x^2 /; 0 \[LessEqual] x < 1\), 
    \(f[x_] := 2 + x /; 1 \[LessEqual] x\), 
    \({f[\(-2\)], f[0], f[1]}\)}], "Input"],

Cell["Otro ejemplo.", "Text"],

Cell[BoxData[{
    \(Clear[f]\nf[x_, y_] := 
      Log[x + y] /; 0 < x + y\  && \ x^2 + y^2 < 16\nf[\(-3\), 2]\  (*
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones*) \), 
    \(f[2, 1]\nf[3, 2]\nf[3, 3]\  (*
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algunos comandos para trabajar con funciones elementales", "Section"],

Cell["\<\
Los siguientes comandos son \[UAcute]tiles para trabajar con funciones polin\
\[OAcute]micas.\
\>", "Text"],

Cell[BoxData[
    \(\(poli = Expand[\((x\  + \ y^2\  + z^3)\)^10] (*
      desarrolla\ la\ potencia*) \)\)], "Input"],

Cell["\<\
Lo contrario de desarrollar una potencia es agrupar en factores (cuando se \
puede). \
\>", "Text"],

Cell[BoxData[
    \(Factor[poli]\)], "Input"],

Cell[TextData[{
  "Recuerda que el s\[IAcute]mbolo \"",
  StyleBox["%",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["se refiere a la salida inmediata anterior",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Expand[\((x + y + z)\) \((x^2 + y^3 + z^4 + 2)\) \((1 + 
            x^2)\)]\)], "Input"],

Cell[BoxData[
    \(Factor[%]\)], "Input"],

Cell[BoxData[
    \(\(poli2 = 
      Expand[\((1 + x + y*x\  + \ x*z^2)\)^3]\nCollect[poli2, x]\  (*
      agrupa\ t\[EAcute]rminos\ con\ igual\ potencia\ de\ x*) \)\)], "Input"],

Cell[BoxData[
    \(\(Coefficient[poli2, x^3] (*nos\ da\ el\ coeficiente\ de\ x^3*) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Exponent[poli2, z]\n (*nos\ da\ el\ exponente\ m\[AAcute]ximo\ de\ z, 
      \ es\ decir, \ el\ grado\ de\ poli2\ en\ la\ variable\ z*) \)\)], 
  "Input"],

Cell[TextData[{
  "El comando \"",
  StyleBox["Simplify[expr]",
    FontWeight->"Bold"],
  "\" sirve para simplificar una expresi\[OAcute]n. Cuando se usa con \
polinomios trata de presentarlos de la forma m\[AAcute]s sencilla y para ello \
puede factorizarlos o no."
}], "Text"],

Cell[BoxData[
    \(Simplify[\((1 - x)\)^4 - \((1 + x)\)^3]\)], "Input"],

Cell[BoxData[
    \(Simplify[\((1 - x)\)^4 + \((1 + x)\)^3]\)], "Input"],

Cell[TextData[{
  "Un comando m\[AAcute]s poderoso (y m\[AAcute]s lento) que Simplify es \"",
  StyleBox["FullSimplify[expr]",
    FontWeight->"Bold"],
  "\". A veces el primero no da resultado y el segundo s\[IAcute]."
}], "Text"],

Cell[BoxData[
    \(\(Simplify[
      2^\((1/2)\) + 3^\((1/2)\) - \((5 + 2*6^\((1/2)\))\)^\((1/2)\)] (*
      no\ hace\ nada*) \)\)], "Input"],

Cell[BoxData[
    \(\(FullSimplify[
      2^\((1/2)\) + 3^\((1/2)\) - \((5 + 2*6^\((1/2)\))\)^\((1/2)\)]\  (*
      simplifica\ la\ expresi\[OAcute]n*) \)\)], "Input"],

Cell["\<\
Los siguientes comandos son \[UAcute]tiles para trabajar con funciones \
racionales.\
\>", "Text"],

Cell[BoxData[{
    \(Numerator[\(x^3 + x - 1\)\/\(x^2 - 5\)] (*proporciona\ el\ numerador*) 
      \), 
    \(Denominator[\(x^3 + x - 1\)\/\(x^2 - 5\)] (*
      proporciona\ el\ denominador*) \)}], "Input"],

Cell[BoxData[
    \(\(Together[\(x^3 + x - 1\)\/\(x^2 - 5\) + \(x - 1\)\/\(x^2 + 1\)] (*
      junta\ los\ sumandos\ en\ una\ sola\ fracci\[OAcute]n*) \)\)], "Input"],

Cell[BoxData[
    \(\(Apart[\(x^3 + x - 1\)\/\(\((x - 5)\) \((x^2 + 1)\) \((x + 2)\)^2\)] (*
      descompone\ en\ fracciones\ simples*) \)\)], "Input"],

Cell[BoxData[
    \(\(Cancel[\(x^3 - 1\)\/\(\((x - 1)\) \((x^2 + 1)\)\)] (*
      cancela\ factores\ comunes*) \)\)], "Input"],

Cell[BoxData[
    \(\(ExpandAll[
      \(\((x + 1)\) \((1 + x + x^2)\)\)\/\(\((x - 5)\) \((x + 2)\)\)] (*
      expande\ numerador\ y\ denominador*) \)\)], "Input"],

Cell[BoxData[
    \(\(Expand[
      \(\((x + 1)\) \((1 + x + x^2)\)\)\/\(\((x - 5)\) \((x + 2)\)\)] (*
      expande\ el\ numerador*) \)\)], "Input"],

Cell[TextData[{
  "Las principales funciones trigonom\[EAcute]tricas de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " son Sin[x], Cos[x], Tan[x], ArcSin[x], ArcCos[x], ArcTan[x]. Ya habr\
\[AAcute]s observado que todos los comandos y funciones de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " empiezan por may\[UAcute]sculas. Por eso es conveniente que las funciones \
que t\[UAcute] definas tengan nombre en letras min\[UAcute]sculas. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce las identidades trigonom\[EAcute]tricas y puede usarlas para \
simplificar expresiones en las que aparezcan dichas funciones. En lugar de \
Expand[ ] y Factor[ ] se usan los comandos TrigExpand[ ] y TrigFactor[ ]."
}], "Text"],

Cell[BoxData[
    \(TrigExpand[Cos[x + y]]\)], "Input"],

Cell[BoxData[
    \(TrigExpand[Sin[2  ArcTan[t]]]\)], "Input"],

Cell[BoxData[
    \(\(TrigReduce[Sin[a*x]*Cos[b*x]\^2] (*
      convierte\ productos\ de\ funciones\ trigonom\[EAcute]tricas\ en\ 
        sumas*) \)\)], "Input"],

Cell[BoxData[
    \(TrigFactor[%]\)], "Input"],

Cell[TextData[{
  "La funci\[OAcute]n exponencial de base ",
  StyleBox["a",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((a > 0, \ a \[NotEqual] \ 1)\)\)]],
  " es la funci\[OAcute]n que a un n\[UAcute]mero ",
  StyleBox["x",
    FontSlant->"Italic"],
  " hace corresponder ",
  Cell[BoxData[
      \(TraditionalForm\`a\^x\)]],
  ". La exponencal de base \[ExponentialE] se llama exponencial natural. "
}], "Text"],

Cell[BoxData[{
    \(2^\((3.14)\) (*
      a^x\ representa\ el\ valor\ en\ x\ de\ la\ funci\[OAcute]n\ exponencial
        \ de\ base\ a*) \), 
    \(Exp[3.14]\  (*Exp[x]\ es\ la\ funci\[OAcute]n\ exponencial\ natural*) 
      \)}], "Input"],

Cell[BoxData[
    \(\(Limit[\((1.1)\)^x, x \[Rule] \(+Infinity\)] (*
      la\ funci\[OAcute]n\ exponencial\ de\ base\ a > 
        1\ tiene\ l\[IAcute]mite\  + \[Infinity]\ en\  + \[Infinity]\ *) 
      \)\)], "Input"],

Cell[BoxData[
    \(\(Limit[\((1.1)\)^x, x \[Rule] \(-Infinity\)] (*
      la\ funci\[OAcute]n\ exponencial\ de\ base\ a > 
        1\ tiene\ l\[IAcute]mite\ 0\ en\  - \[Infinity]*) \)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce la propiedad principal de las exponenciales: la exponencial de una \
suma es el producto de las exponenciales de los sumandos. Observa en la celda \
siguiente el uso del operador boleano \"==\" para comprobar que dos \
expresiones simb\[OAcute]licas son iguales."
}], "Text"],

Cell[BoxData[
    \(a\^\(x + y\) == a\^x*a\^y\)], "Input"],

Cell[TextData[{
  "Dado un n\[UAcute]mero positivo ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] 1\)]],
  ",  y un n\[UAcute]mero real ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ", se define el logaritmo en base ",
  StyleBox["a",
    FontSlant->"Italic"],
  " de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " como el \[UAcute]nico n\[UAcute]mero real ",
  StyleBox["y",
    FontSlant->"Italic"],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`a\^y = x\)]],
  ". Los logaritmos en base \[ExponentialE] se llaman logaritmos naturales (o \
neperianos). "
}], "Text"],

Cell[BoxData[{
    \(Log[10. ]\  (*Log[x]\ es\ el\ logaritmo\ natural\ de\ x*) \), 
    \(Log[10, 10. ]\  (*Log[a, x]\ es\ el\ logaritmo\ de\ x\ en\ base\ a*) 
      \)}], "Input"],

Cell[BoxData[
    \(\(Limit[Log[2, x], x \[Rule] \(+\[Infinity]\)]\  (*
      el\ l\[IAcute]mite\ en\  + 
          \[Infinity]\ de\ la\ funci\[OAcute]n\ logaritmo\ de\ base\ a > 
        1\ es\  + \[Infinity]*) \)\)], "Input"],

Cell[BoxData[
    \(\(Limit[Log[2, x], x \[Rule] 0]\  (*
      el\ l\[IAcute]mite\ en\ 0\ de\ la\ funci\[OAcute]n\ logaritmo\ de\ base
          \ a > 1\ es\  - \[Infinity]*) \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listas", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " una lista es cualquier expresi\[OAcute]n que empiece con \"{\" y termine \
con \"}\". Ejemplos de listas son {1,2,3}, {Cos[x],Sin[y]}, {a,{b,c}}, \
{{1,2},{3,4}}. Una lista es realmente un vector (cuyos elementos pueden ser \
de muy variada naturaleza) por eso el orden en que se escriben sus elementos \
es importante."
}], "Text"],

Cell[BoxData[
    \(\({1, 2} == {2, 1}\  (*son\ listas\ distintas*) \)\)], "Input"],

Cell["\<\
Los comandos que se usan con mayor frecuencia para generar listas son Table[ \
] y Range[ ].\
\>", "Text"],

Cell["\<\
Table[expr, {k}] genera una lista con k copias de expr. 
Table[expr, {i, imax}] genera una lista de los valores de expr cuando i \
recorre los valores 1,2,... hasta imax. 
Table[expr, {i, imin, imax}] genera una lista de los valores de expr cuando i \
recorre los valores imin, imin+1,... hasta llegar sin exceder imax. Los \
valores imin, imax pueden o no ser enteros.
Table[expr, {i, imin, imax, inc}] igual que el anterior pero con incrementos \
iguales a inc. 
Table[expr, {i, imin, imax}, {j, jmin, jmax}, \[Ellipsis] ] produce una lista \
de listas (una lista anidada). Para cada valor del \[IAcute]ndice i se \
recorren todos los valores del \[IAcute]ndice j.
Range[k] genera una lista con los primeros k enteros positivos.
Range[a, b] genera una lista que empieza en a con incrementos de una unidad \
hasta llegar a b sin excederlo. Los n\[UAcute]meros a y b pueden o no ser \
enteros.
Range[a, b, inc]  igual que el anterior pero con incrementos iguales a inc. \
\
\>", "Text"],

Cell[BoxData[{
    \(Table[Sin[x], {3}]\), 
    \(Table[Random[\ ], {10}]\  (*
      genera\ 10\ n\[UAcute]meros\ aleatorios\ comprendidos\ entre\ 0\ y\ 1*) 
      \), 
    \(Table[2^i, {i, 6}]\), 
    \(Table[i^2, {i, 3, 7}]\), 
    \(Table[i^2, {i, 3.5, 7}]\), 
    \(Table[i^2, {i, 3.5, 7, 0.5}]\), 
    \(Table[n^m, {m, 2}, {n, 3.5, 7, 0.5}]\), 
    \(Range[5]\), 
    \(Range[2.7, 9]\), 
    \(Range[2.7, 9,  .8]\)}], "Input"],

Cell["\<\
Cuando tengas que trabajar con listas de muchos elementos el comando Range[ ] \
suele ser m\[AAcute]s r\[AAcute]pido que Table[ ].\
\>", "Text"],

Cell[BoxData[{
    \(\(Timing[Table[i, {i, 200000}]]\)[\([1]\)]\  (*
      tiempo\ que\ tarda\ Table[\ ]\ en\ generar\ los\ primeros\ doscientos\ 
        mil\ n\[UAcute]meros*) \t\t\), 
    \(\(Timing[Range[200000]]\)[\([1]\)]\n (*
      tiempo\ que\ tarda\ Range[\ ]\ en\ generar\ los\ primeros\ doscientos\ 
        mil\ n\[UAcute]meros*) \)}], "Input"],

Cell[TextData[{
  StyleBox["Una particularidad de ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " extraordinariamente \[UAcute]til es que casi todas las funciones de ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" pueden trabajar con listas.",
    FontWeight->"Bold"],
  " Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(Sin[Range[1. , 2,  .1]]\), 
    \(Range[1, 7]^2\), 
    \(1/Range[1, 7]\), 
    \({Range[1, 3], Range[4, 7]}^2\)}], "Input"],

Cell["\<\
El comando Length[lista] proporciona el n\[UAcute]mero de elementos de una \
lista.\
\>", "Text"],

Cell[BoxData[{
    \(Length[{1, 2, 3, 4}] (*una\ lista\ con\ 4\ elementos*) \), 
    \(Length[{1, {2, 3, 4}}] (*una\ lista\ con\ 2\ elementos*) \)}], "Input"],

Cell["\<\
Una matriz es una lista cuyos elementos son listas simples (las filas) de \
igual longitud (n\[UAcute]mero de columnas).\
\>", "Text"],

Cell[BoxData[
    \(\(A = Table[\(-i\)*j + 2  j, {i, 3}, {j, 4}]\  (*
      una\ matriz\ de\ 3\ filas\ y\ 4\ columnas\ *) \)\)], "Input"],

Cell[TextData[StyleBox[
"Podemos sumar y multiplicar listas de igual longitud. El producto y la suma \
de listas se hace elemento a elemento, es decir, se multiplican o se suman \
los elementos que ocupan el mismo lugar en cada una de las listas.",
  FontWeight->"Bold"]], "Text"],

Cell[BoxData[
    \(\({a, b, 
        c} + {x, y, z}\  (*suma\ de\ listas\ *) \n{a, b, c} {x, y, z}\  (*
          producto\ de\ listas\ elemento\ a\ elemento\ *) 
          \n{{a, b}, {1, 2, 3}} {{2, 3}, {x, y, z}}\  (*
      producto\ de\ listas\ elemento\ a\ elemento\ *) \)\)], "Input"],

Cell["\<\
Para multiplicar dos matrices con las dimensiones apropiadas se escribe \".\" \
entre ellas dos. Para multiplicar matrices debes representarlas como \
listas.\
\>", "Text"],

Cell[BoxData[
    \(B = Table[i*j - 2  j, {i, 4}, {j, 3}]\)], "Input"],

Cell[BoxData[
    \(M = A . B\)], "Input"],

Cell["Observa la diferencia.", "Text"],

Cell[BoxData[{
    \(M\ M\  (*producto\ como\ listas\ M*M = M^2*) \), 
    \(M . M\  (*producto\ matricial*) \), 
    \({a, b, c} {x, y, z}\  (*producto\ como\ listas*) \), 
    \({a, b, c} . {x, y, z}\  (*producto\ escalar\ de\ dos\ vectores*) \)}], 
  "Input"],

Cell["\<\
El comando Reverse[lista] invierte el orden de los elementos de la lista.\
\>", "Text"],

Cell[BoxData[
    \(Reverse[{a, b, c, d, e}]\)], "Input"],

Cell["\<\
El comando Transpose[listadelistas] intercambia los primeros dos niveles en \
\"listadelistas\". Cuando se trata de una matriz cambia filas por columnas.\
\>", "Text"],

Cell[BoxData[
    \(Transpose[A]\)], "Input"],

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    \(Transpose[{{{1, 2}, {3, 4}}, {5, 6}, {7, 8}}]\)], "Input"],

Cell["\<\
El comando Sort[lista] ordena los elementos de una lista. Last[lista] y \
First[lista] nos dan el \[UAcute]ltimo y el primer elemento de una lista. \
Max[lista] y Min[lista] nos dan el m\[AAcute]ximo y el m\[IAcute]nimo \
elemento de una lista num\[EAcute]rica.\
\>", "Text"],

Cell[BoxData[{
    \(Sort[{u, x, v, c, a, f, e}]\ \  (*ordena\ lexicogr\[AAcute]ficamente*) 
      \), 
    \(Sort[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*
      ordena\ de\ menor\ a\ mayor*) \), 
    \(Last[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*
      \[UAcute]ltimo\ elemento*) \t\), 
    \(First[{u, x, v, c, a, f, e}]\ \ \  (*primer\ elemento*) \), 
    \(Max[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \ \), 
    \(Min[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \)}], "Input"],

Cell["\<\
Los comandos Append[lista,elemento] y Prepend[lista,elemento] agregan \
\"elemento\" al final o al principio de \"lista\".\
\>", "Text"],

Cell[BoxData[{
    \(Append[{a, b, c}, 1]\), 
    \(Append[{a, b, c}, {1, 2}]\), 
    \(Prepend[{a, b, c}, 1]\), 
    \(Prepend[{a, b, c}, {1, 2}]\)}], "Input"],

Cell["\<\
Para extraer o eliminar elementos de una lista se usan \
Take[lista,{numero1,numero2}] y Drop[lista,{numero1,numero2}].\
\>", "Text"],

Cell[BoxData[{
    \(Take[{a, b, c, d, e, f}, {2, 4}]\  (*
      extrae\ los\ elmentos\ comprendidos\ entre\ el\ segundo\ y\ el\ cuarto\ 
        ambos\ inclusive*) \), 
    \(Take[{a, b, c, d, e, f}, 3]\  (*extrae\ los\ primeros\ 3\ elementos*) 
      \), 
    \(Take[{a, b, c, d, e, f}, \(-3\)] (*
      extrae\ los\ \[UAcute]ltimos\ 3\ elementos*) \)}], "Input"],

Cell[BoxData[{
    \(Drop[{a, b, c, d, e, f}, {2, 4}]\  (*
      elimina\ los\ elmentos\ comprendidos\ entre\ el\ segundo\ y\ el\ cuarto
        \ ambos\ inclusive*) \), 
    \(Drop[{a, b, c, d, e, f}, 3]\  (*elimina\ los\ primeros\ 3\ elementos*) 
      \), 
    \(Drop[{a, b, c, d, e, f}, \(-3\)]\  (*
      elimina\ los\ \[UAcute]ltimos\ 3\ elementos*) \ \)}], "Input"],

Cell["\<\
Un comando que es muy \[UAcute]til para trabajar con listas es el comando \
Flatten[ ] que convierte una lista de listas en una lista.\
\>", "Text"],

Cell[BoxData[
    \(Flatten[{{1, 2, 3}, {4, 5, 6}, {{7, 8}, {9, 10}}}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de much\[IAcute]simos comandos para trabajar con listas. Uno de \
los m\[AAcute]s \[UAcute]tiles con el que acabamos esta secci\[OAcute]n es el \
comando Outer[f, lista1, lista2] donde f puede ser una funci\[OAcute]n o un \
comando."
}], "Text"],

Cell[BoxData[
    \(Outer[f, {a, b, c}, {1, 2, 3, 4}]\)], "Input"],

Cell[BoxData[
    \(Outer[List, {a, b, c}, {u, v, x}]\)], "Input"],

Cell[BoxData[
    \(Transpose[%]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Aplicar una funci\[OAcute]n a los elementos de una lista: comandos  Map y \
Apply.\
\>", "Section"],

Cell[TextData[{
  "En general, para aplicar una funci\[OAcute]n a los elementos de una lista, \
se usa el comando Map[funcion,lista] donde \"funcion\" debe ser el ",
  StyleBox["nombre",
    FontSlant->"Italic"],
  " de la funci\[OAcute]n.Este comando tambi\[EAcute]n se escribe en la forma \
f/@expr. "
}], "Text"],

Cell[BoxData[{
    \(Map[funcion, {a, b, c}]\), 
    \(Map[1/x, {1, 2, 3}]\  (*no\ es\ correcto*) \), 
    \(inverso[x_] := 1/x\), 
    \(Map[inverso, {1, 2, 3}]\), 
    \(inverso/@{1, 2, 3}\)}], "Input"],

Cell[TextData[{
  "Con mucha frecuencia hay que aplicar una funci\[OAcute]n de varias \
variables a un vector o a los elementos de una lista cuyos elementos son \
vectores con igual n\[UAcute]mero de elementos que variables tiene la funci\
\[OAcute]n. La dificultad est\[AAcute] en que las funciones en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conviene definirlas de la forma func[x,y] o func[x,y,z] y as\[IAcute] \
definidas no pueden trabajar directamente sobre vectores de la forma {x,y} o \
{x,y,z}. No es lo mismo f[1,2] que f[{1,2}]. Observa la (importante) \
diferencia."
}], "Text"],

Cell[BoxData[
    \(\(f[x_, y_] = x + y\^2; 
    \n{f[{1, 2}], f[1, 2]}\  (*
      la\ funci\[OAcute]n\ no\ sabe\ actuar\ sobre\ {1, 2}*) \)\)], "Input"],

Cell["\<\
El comando Apply[func,expr] es \[UAcute]til para esto. Este comando tambi\
\[EAcute]n se escribe en la forma f@@expr. Este comando tiene un \
par\[AAcute]metro opcional que indica el nivel al que act\[UAcute]a \
Apply[func,expr,nivel]. La opci\[OAcute]n por defecto es nivel=0 que se \
refiere a toda la expresi\[OAcute]n. Es frecuente usar nivel=1 que se refiere \
a los elementos de primer nivel de la expresi\[OAcute]n.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(Apply[f, {a, b}]\), 
    \(Apply[f, {{a, b}, {c, d}, {u, v, w}}] (*
      aqu\[IAcute]\ Apply\ se\ aplica\ a\ toda\ la\ expresi\[OAcute]n*) \), 
    \(Apply[f, {{a, b}, {c, d}, {u, v, w}}, 1] (*
      aqu\[IAcute]\ Apply\ se\ aplica\ a\ los\ elementos\ de\ primer\ nivel\ 
        dela\ expresi\[OAcute]n*) \)}], "Input"],

Cell["\<\
Con frecuencia hay que sumar o multiplicar todos los elementos de una lista \
lo que se hace con los comandos Apply[Plus,lista] y Apply[Times,lista].\
\>", "Text"],

Cell[BoxData[{
    \(Apply[Plus, Range[1, 1000]]\  (*
      suma\ de\ los\ 1000\ primeros\ n\[UAcute]meros*) \), 
    \(Apply[Times, Range[1, 10]]\  (*
      producto\ de\ los\ 10\ primeros\ n\[UAcute]meros*) \), 
    \(Apply[Plus, {{2, 3}, {4, 5}}]\  (*
      suma\ las\ listas\ elemento\ a\ elemento*) \), 
    \(Apply[Times, {{2, 3}, {4, 5}}]\  (*
      multiplica\ las\ listas\ elemento\ a\ elemento*) \)}], "Input"],

Cell["\<\
Naturalmente, la funci\[OAcute]n \"func\" en Apply[func,expr] puede ser \
cualquier funci\[OAcute]n que definamos nosotros.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_, y_, z_] := {g[x, y, z], h[x, y, z]}; \nApply[f, {a, b, c}]\), 
    \(Clear[f, g, h]\)}], "Input"],

Cell[TextData[{
  "Como puedes ver, para",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " no es lo mismo \"expr\" que {\"expr\"} que {{\"expr\"}}. ",
  "Observa las diferencias entre Apply[func,expr] y Map[func, expr]."
}], "Text"],

Cell[BoxData[{
    \({Map[f, {a, b, c}], Apply[f, {a, b, c}]}\), 
    \({Map[f, {{a, b}, {c, d}}], Apply[f, {{a, b}, {c, d}}, 1]}\)}], "Input"],

Cell[TextData[{
  "Otra forma de hacer esto, quiz\[AAcute]s m\[AAcute]s f\[AAcute]cil \
consiste en lo siguiente. ",
  StyleBox["Cuando definas una funci\[OAcute]n debes tener en cuenta sobre qu\
\[EAcute] tipo de elementos debe poderse evaluar. ",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \(f[x_, y_] = x^2  y + x^y; \ \nf[2, 3]\), 
    \(f[{2, 3}] (*no\ est\[AAcute]\ definido*) \)}], "Input"],

Cell["\<\
Si queremos poder evaluar directamente esta funci\[OAcute]n sobre una lista \
de vectores podemos ampliar su definici\[OAcute]n como sigue.\
\>", "Text"],

Cell[BoxData[{
    \(f[{x_, y_}] = f[x, y];  (*esta\ es\ la\ novedad*) \[IndentingNewLine]f[
      2, 3]\), 
    \(f[{2, 3}]\), 
    \(Map[f, {{2, \(-1\)}, {2, 3}}]\)}], "Input"],

Cell[TextData[{
  StyleBox[
  "Cuando definas una funci\[OAcute]n has de tener en cuenta el tipo de \
variable con el que va a trabajar dicha funci\[OAcute]n y definirla de forma \
adecuada",
    FontWeight->"Bold"],
  ". En el siguiente ejemplo se define una funci\[OAcute]n de 3 variables que \
puede evaluarse directamente sobre listas de la forma {{x},{y,z}}."
}], "Text"],

Cell[BoxData[{
    \(funcion[x_, y_, z_] = {Sin[x], y + z}; \n
    funcion[{{x_}, {y_, z_}}] = funcion[x, y, z]; 
    \n{funcion[Pi/4, 2, 3], funcion[{{Pi/4}, {2, 3}}]}\), 
    \(Map[funcion, Table[{{k\ Pi/2}, {k + 1, k + 2}}, {k, 1, 5}]]\), 
    \(Clear[funcion]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seleccionar elementos en una lista: el comando Select[ ]", "Section"],

Cell["\<\
Para seleccionar el elemento que ocupa el lugar k en una lista se usa la \
sintaxis \"lista[[k]]\".\
\>", "Text"],

Cell[BoxData[{
    \({a, b, c, d}[\([2]\)]\  (*segundo\ elemento\ de\ la\ lista*) \), 
    \(\t\tA = Table[\(-i\)*j + 2  j, {i, 3}, {j, 4}]\  (*
      una\ matriz\ de\ 3\ filas\ y\ 4\ columnas*) \), 
    \(A[\([1]\)]\  (*primer\ elemento\ de\ la\ lista*) \)}], "Input"],

Cell["\<\
En una lista de listas se usa la sintaxis \"lista[[i,j]]\" para seleccionar \
el elemento que ocupa el lugar i de la lista (la fila) y dentro de \[EAcute]l \
el que ocupa el lugar j (la columna).\
\>", "Text"],

Cell[BoxData[
    \(A[\([1, 4]\)]\)], "Input"],

Cell[TextData[{
  StyleBox["Una forma frecuente de seleccionar elementos en una lista se basa \
en el comando Select[lista,criterio de selecci\[OAcute]n]. Hay que definir \
previamente el criterio de selecci\[OAcute]n el cual debe ser una funci\
\[OAcute]n boleana.",
    FontWeight->"Bold"],
  " Para definir esa funci\[OAcute]n es obligado que uses la \
asignaci\[OAcute]n diferida porque en otro caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tratar\[AAcute] de evaluar inmediatamente la expresi\[OAcute]n a la \
derecha lo que dar\[AAcute] un error. Aqu\[IAcute] tienes algunos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(mayorque7[x_] := x > 7\  (*
      funci\[OAcute]n\ boleana\ que\ sirve\ para\ seleccionar\ n\[UAcute]meros
        \ mayores\ que\ 7*) \), 
    \(Select[Range[\(-2\), 10], mayorque7]\)}], "Input"],

Cell[BoxData[{
    \(multiplodetres[x_] := IntegerQ[x/3]\  (*
      IntegerQ[z]\ es\ True\ si\ z\ es\ entero\ y\ False\ en\ otro\ caso*) 
      \), 
    \(Select[Range[\(-15\), 15], multiplodetres]\  (*
      seleccionamos\ los\ m\[UAcute]ltiplos\ de\ 3*) \)}], "Input"],

Cell["\<\
Las funciones boleanas OddQ, EvenQ, IntegerQ, NumberQ, VectorQ, PrimeQ, \
NumericQ, Positive, Negative pueden usarse como criterios de \
selecci\[OAcute]n. \
\>", "Text"],

Cell[BoxData[{
    \(Select[Table[3*k, {k, 15}], EvenQ]\  (*
      selecciona\ los\ n\[UAcute]meros\ pares*) \), 
    \(Select[Table[3*k, {k, 15}], OddQ]\  (*
      selecciona\ los\ n\[UAcute]meros\ impares*) \), 
    \(Select[{1, {2, 3}, a, {c}, {{d, e}}}, VectorQ]\  (*
      selecciona\ listas\ simples*) \), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Positive]\), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Negative]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convertir procedimientos en funciones", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy f\[AAcute]cil convertir procedimientos en funciones. Es decir, una \
vez que has realizado una tarea para un caso concreto es muy sencillo definir \
una funci\[OAcute]n que realice esa misma tarea en cualquier \
situaci\[OAcute]n an\[AAcute]loga. Consideremos el siguiente procedimiento \
que consiste en seleccionar entre los primeros 10000 enteros aquellos que son \
cuadrados perfectos."
}], "Text"],

Cell[BoxData[
    \(cuadrado[x_] := IntegerQ[Sqrt[x]]; \n
    Select[Range[1, 10000], cuadrado]\)], "Input"],

Cell["\<\
Para convertir este procedimiento en una funci\[OAcute]n tomamos como \
variable la lista a la que se va a aplicar y la funci\[OAcute]n de selecci\
\[OAcute]n la mantenemos igual. Ello nos lleva a definir la funci\[OAcute]n \
siguiente.\
\>", "Text"],

Cell[BoxData[
    \(seleccionacuadrados[z_] := Select[z, cuadrado]\)], "Input"],

Cell["\<\
Naturalmente para que esta funci\[OAcute]n haga su trabajo debemos definir \
antes el criterio de selecci\[OAcute]n \"cuadrado\". Adem\[AAcute]s la \
variable z debe ser una lista. Por ejemplo, podemos seleccionar de entre los \
primeros 100 cubos aquellos que tambi\[EAcute]n son cuadrados.\
\>", "Text"],

Cell[BoxData[
    \(seleccionacuadrados[Table[k^3, {k, 1, 100}]]\)], "Input"],

Cell["\<\
Podemos definir funciones cuyas variables son funciones. Por ejemplo la funci\
\[OAcute]n siguiente lo que hace es evaluar una funci\[OAcute]n f en los \
puntos de una lista y despu\[EAcute]s suma los valores obtenidos.\
\>", "Text"],

Cell[BoxData[
    \(sumalista[funcion_, lista_] := Apply[Plus, Map[f, lista]]\)], "Input"],

Cell["\<\
Para que este comando act\[UAcute]e debemos pasarle una \"funci\[OAcute]n\" \
que pueda actuar sobre los elementos de \"lista\" y proporcione resultados \
que puedan sumarse.\
\>", "Text"],

Cell[BoxData[
    \(f[x_] := x^2 + Exp[x]; \nsumalista[f, Range[10]]\)], "Input"],

Cell[BoxData[
    \(f[{x_, y_}] = {x, x + y}; \nsumalista[f, Table[{n, n}, {n, 10}]]\)], 
  "Input"],

Cell[TextData[{
  "Una forma de decirla a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que haga varias cosas pero que solamente muestre en pantalla la \
\[UAcute]ltima operaci\[OAcute]n, es usar una lista con todas las cosas que \
queremos que haga separadas por punto y coma. Por ejemplo."
}], "Text"],

Cell[BoxData[{
    \(Clear[seleccionacuadrados, cuadrado]\), 
    \(seleccionacuadrados[x_] := {
        cuadrado[z_] := IntegerQ[Sqrt[z]]\  (*
          aqu\[IAcute]\ definimos\ el\ criterio\ de\ selecci\[OAcute]n\ y\ no
            \ se\ puede\ repetir\ la\ variable\ x*) ; Select[x, cuadrado]}
        \), 
    \(seleccionacuadrados[Range[10000]]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reglas de sustituci\[OAcute]n. Operador de sustituci\[OAcute]n", \
"Section"],

Cell["\<\
Cuando queremos sustituir en una expresi\[OAcute]n un s\[IAcute]mbolo por un \
valor o por otro s\[IAcute]mbolo puede no ser conveniente usar el comando de \
asignaci\[OAcute]n (=) porque dicho comando atribuye un valor fijo \"para \
siempre\". El siguiente ejemplo explica lo que quiero decirte.\
\>", "Text"],

Cell[BoxData[
    \(\(polixy = x*y^2 + 3  x + 4  y\ 
    \n (*una\ expresi\[OAcute]n\ algebraica\ en\ la\ que\ intervienen\ dos\ 
        variables\ "\<x\>"\ e\ "\<y\>"\ *) \)\)], "Input"],

Cell["\<\
Podemos querer sustituir en dicha expresi\[OAcute]n la variable \"x\" por 7. \
Una forma de hacerlo es como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(\(x = 7\n
    polixy\)\(\ \ \ \)\)\)], "Input"],

Cell[TextData[{
  "El inconveniente de esto es que \"polixy\" ha cambiado y \"x\" ya no es \
una variable. Hay otra forma de proceder que consiste en decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"sustituye x por 7\" pero deja \"polixy\" igual que est\[AAcute] y adem\
\[AAcute]s \"x\" debe seguir siendo una variable. Para ello necesitas DOS \
comandos: una ",
  StyleBox["regla de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`x -> 7\)]],
  ") y el ",
  StyleBox["comando de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " ( ",
  StyleBox["/.",
    FontWeight->"Bold"],
  " ). Una",
  StyleBox[" regla de sustituci\[OAcute]n inmediata",
    FontWeight->"Bold"],
  " es un comando de la forma \"",
  Cell[BoxData[
      \(TraditionalForm\`expr1 -> expr2\)],
    FontWeight->"Bold"],
  "\" que representa una regla que transforma \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" en \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\". Puedes escribir ",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  " con mejor apariencia tecleando \"Esc",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "Esc\". Este es el resultado \[Rule]. Por s\[IAcute] sola una regla no hace \
nada. Para aplicar una regla necesitas el operador de sustituci\[OAcute]n \
cuya sintaxis es de la forma \"",
  StyleBox["expr /. regla",
    FontWeight->"Bold"],
  "\" o \"",
  StyleBox["expr /. {regla1, regla2,...}",
    FontWeight->"Bold"],
  "\" que aplica una regla o varias reglas ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de evaluar \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\". Por ejemplo \"",
  StyleBox["expr1 /. b\[Rule]c",
    FontWeight->"Bold"],
  "\"",
  StyleBox[" ",
    FontWeight->"Bold"],
  "significa que en la expresi\[OAcute]n \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["despu\[EAcute]s de ser evaluada",
    FontSlant->"Italic"],
  " todas las apariciones de ",
  StyleBox["b",
    FontWeight->"Bold"],
  " deben ser sustituidas por ",
  StyleBox["c",
    FontWeight->"Bold"],
  ". Observa su uso."
}], "Text"],

Cell[BoxData[{
    \(Clear[x]\ \ \ \  (*limpiamos\ el\ s\[IAcute]mbolo\ x\ *) \), 
    \(polixy\ \ \ \ \ \ \ \ \  (*polixy\ vuelve\ a\ ser\ lo\ que\ era\ *) \n
        polixy /. x \[Rule] 7\ \ \ \ \n
    \t\t (*atribuimos\ a\ x\ el\ valor\ 7\ obteniendo\ igual\ resultado\ que\ 
        antes\ *) \), 
    \(polixy\ \ \ \ \ \ \ \ \  (*polixy\ no\ ha\ cambiado\ *) \)}], "Input"],

Cell[BoxData[
    \(\(?x\ \ \ \ (*x\ sigue\ siendo\ una\ variable\ *)\)\)], "Input"],

Cell[TextData[{
  " Cuando en un comando del tipo \"",
  StyleBox["expr /. regla",
    FontWeight->"Bold"],
  "\" no puede aplicarse ninguna regla de sustituci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " devuelve \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" sin cambio ninguno."
}], "Text"],

Cell[BoxData[
    \(a + 3  b /. c \[Rule] 2\)], "Input"],

Cell[TextData[{
  "Es importante advertir que ",
  StyleBox["el operador de sustituci\[OAcute]n aplica las reglas de sustituci\
\[OAcute]n exactamente una sola vez en cada parte de la expresi\[OAcute]n que \
hay a su izquierda",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(3 \( x\^2\) Cos[1 + x + x\^2] /. {x\^2 \[Rule] x, 
        x \[Rule] a}\)], "Input"],

Cell["\<\
Si aplicamos una lista de listas de reglas de sustituci\[OAcute]n obtenemos \
como resultado una lista cuyos elementos se obtienen aplicando cada una de \
las reglas de sustituci\[OAcute]n a la expresi\[OAcute]n que hay a la \
izquierda.\
\>", "Text"],

Cell[BoxData[
    \(3 \( x\^2\) 
        Cos[1 + x + x\^2] /. {{x\^2 \[Rule] x}, {x \[Rule] a}}\)], "Input"],

Cell["\<\
Puedes aplicar reglas de sustituci\[OAcute]n a \"patrones\" de forma parecida \
a como se definen funciones. Aqu\[IAcute] tienes dos ejemplos. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, {4, 5}, 6} /. x_?NumberQ \[Rule] {x, 0}\)], "Input"],

Cell[BoxData[
    \({{1, 0}, {2, 0}, {3, 0}, {{4, 0}, {5, 0}}, {6, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Esta regla le dice a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que busque los n\[UAcute]meros \"x\" que hay en la expresi\[OAcute]n de \
la izquierda y los sustituya por {x,0}."
}], "Text"],

Cell[BoxData[
    \(f[a] + f[a + b] + f[b*c] \((u + v)\) /. f[x_] \[Rule] x^2\)], "Input"],

Cell[TextData[{
  "Esta regla le dice a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que busque en la expresi\[OAcute]n de la izquierda los elementos de la \
forma \"f[algo]\" y los sustituya por algo^2."
}], "Text"],

Cell[TextData[{
  "Al igual que ocurre con la asignaci\[OAcute]n diferida (",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  ") tambi\[EAcute]n es posible dar ",
  StyleBox["reglas de sustituci\[OAcute]n diferidas",
    FontWeight->"Bold"],
  " \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` :> \)],
    FontWeight->"Bold"],
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" (que es otra manera de escribir ",
  StyleBox["RuleDelayed[expr1,expr2]",
    FontWeight->"Bold"],
  "). Puedes escribir ",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  " con mejor apariencia si tecleas \"Esc",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  "Esc\". Este es el resultado \[RuleDelayed]. En el siguiente ejemplo puedes \
apreciar la diferencia entre usar unas u otras."
}], "Text"],

Cell[BoxData[
    \(\({x, x, x, x, x} /. x \[Rule] Random[]\ 
    \n (*aqu\[IAcute]\ se\ ejecuta\ inmediatamente\ Random[]\ y\ x\ queda\ 
        sustituido\ por\ el\ valor\ devuelto\ por\ Random[]*) \)\)], "Input"],

Cell[BoxData[
    \(\({x, x, x, x, x} /. x \[RuleDelayed] \ Random[]\ 
    \n (*aqu\[IAcute]\ se\ ejecuta\ Random[]\ cada\ vez\ que\ se\ aplica\ la\ 
        regla\ de\ sustituci\[OAcute]n\ y\ en\ cada\ caso\ x\ queda\ 
        sustituido\ por\ el\ valor\ devuelto\ por\ Random[]*) \)\)], "Input"],

Cell[TextData[{
  "Ten en ecuenta que cuando se ejecuta un comando de la forma \"",
  StyleBox["epr1 /. expr2[x_,y_,...]\[Rule]expr3[x,y,...]\"",
    FontWeight->"Bold"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " primero eval\[UAcute]a \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\", despu\[EAcute]s eval\[UAcute]a la regla de sustituci\[OAcute]n \"",
  StyleBox["expr2[x_,y_,...]\[Rule]expr3[x,y,...]",
    FontWeight->"Bold"],
  "\" y finalmente realiza la sustituci\[OAcute]n indicada. Por eso cuando en \
la regla \"",
  StyleBox["expr2[x_,y_,...]\[Rule]expr3[x,y,...]",
    FontWeight->"Bold"],
  "\" se realizan operaciones simb\[OAcute]licas",
  StyleBox[",",
    FontSlant->"Italic"],
  " por ejemplo",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x_/y_\),
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[Rule]",
            FontWeight->"Bold"], 
          StyleBox[\(Simplify[x\ /y]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", estas se ejecutar\[AAcute]n ",
  StyleBox["antes",
    FontSlant->"Italic"],
  " de aplicar la regla lo que, en este caso al ser ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Simplify[x/y] = x/y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " (pues ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " e ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  " son solamente s\[IAcute]mbolos y nada hay que simplificar), obtendr\
\[IAcute]amos la regla ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x_/y_\),
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[Rule]",
            FontWeight->"Bold"], 
          StyleBox[\(x\ /y\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " que no har\[IAcute]a absolutamente nada. Estos casos se solucionan usando \
una regla de sustituci\[OAcute]n diferida de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x_",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["/",
              FontWeight->"Bold"], 
            StyleBox["y_",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[RuleDelayed]",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["Simplify",
              FontWeight->"Bold"], 
            StyleBox["[",
              FontWeight->"Bold"], 
            StyleBox[\(x/y\),
              FontWeight->"Bold"], "]"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(x\^2 - 1\)\/\(x + 1\) /. x_/y_ \[Rule] Simplify[x/y]\  (*
      no\ hace\ nada*) \), 
    \(\(x\^2 - 1\)\/\(x + 1\) /. x_/y_ \[RuleDelayed] \ Simplify[x/y]\  (*
      simplifica*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre el comando Print[ ]", "Section"],

Cell[TextData[{
  "El comando Print[\"cadena de texto\"] debe usarse ",
  StyleBox["muy poco",
    FontWeight->"Bold"],
  " en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " saca ",
  StyleBox["todo",
    FontSlant->"Italic"],
  " en pantalla por lo que solamente hay que peocuparse de lo que NO queremos \
que muestre en pantalla (poniendo un ; al final) porque lo consideramos una \
informaci\[OAcute]n innecesaria. Pero hay que evitar usar el comando Print[ ] \
para pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre en pantalla lo que el programa ya muestra por s\[IAcute] \
solo. Un inconveniente de Print[ ] es que su salida es considerada siempre \
como una cadena de texto y no puede ser utilizada en ning\[UAcute]n tipo de c\
\[AAcute]lculo num\[EAcute]rico. "
}], "Text"],

Cell[BoxData[{
    \(a = Sin[1.5]\  (*esto\ es\ un\ n\[UAcute]mero\ real*) \), 
    \(b = Print[Sin[1.5]]\  (*
      esto\ no\ es\ un\ n\[UAcute]mero\ sino\ una\ cadena\ de\ texto*) \t\t
    \), 
    \(a + a\  (*se\ puede\ evaluar*) \), 
    \(a + b\  (*no\ se\ puede\ evaluar*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre la evaluaci\[OAcute]n de funciones", "Section"],

Cell[TextData[{
  "Las funciones deben definirse en la forma f[x,y] o f[x,y,z], es decir \
deben incluir todas las variables en un corchete, pues de esta forma se \
pueden evaluar directamente. Para evaluar una funci\[OAcute]n, f[x,y] \
correctamente definida, no hay que atribuir valores a las variables porque es \
un trabajo innecesario e inconveniente. Si queremos evaluar f[x,y] en el \
punto (1,2) basta con escribir f[1,2] y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mostrar\[AAcute] de forma autom\[AAcute]tica, sin necesidad de que \
nosotros lo pidamos, el resultado en pantalla. "
}], "Text"],

Cell[BoxData[{
    \(poli = x\^2*y + y\^3*z + x*y*z\ ;  (*definici\[OAcute]n\ incorrecta*) 
      \[IndentingNewLine]mismopoli[x_, y_, z_] = x\^2*y + y\^3*z + x*y*z\ ; 
    \[IndentingNewLine] (*
      definici\[OAcute]n\ correcta . \ Da\ igual\ aqu\[IAcute]\ que\ usemos\ 
        la\ asignaci\[OAcute]n\ inmediata\ o\ la\ diferida . \ El\ ; \ 
      evita\ la\ salida\ en\ pantalla*) 
      \[IndentingNewLine]poli /. {x \[Rule] 1, y \[Rule] 2, z -> 3}\  (*
      unica\ forma\ de\ evaluar\ "\<poli\>"\ en\ el\ punto\ \((1, 2, 3)\)\ sin
        \ atribuir\ valores\ a\ las\ variables\ x, \ y, \ z, \ cosa\ que, \ 
      adem\[AAcute]s, \ 
      no\ debemos\ hacer\ pues\ "\<poli\>"\ dejar\[IAcute]a\ de\ ser\ una\ 
        funci\[OAcute]n\ y\ pasar\[IAcute]a\ a\ ser\ una\ constante\ hasta\ 
        que\ limpi\[AAcute]ramos\ x, \ y, \ z\ con\ un\ Clear[]*) \), 
    \(mismopoli[1, 2, 3]\  (*
      esta\ es\ la\ forma\ correcta\ de\ evaluar . \ No\ debes\ hacer\ x = 1, 
      \ y = 2, \ 
      z = 3\ y\ despu\[EAcute]s\ pedir\ a\ Mathematica\ el\ valor\ 
          "\<mismopoli[x,y,z]\>"\ porque, \ aunque\ "\<mismopoli\>", \ 
      a\ diferencia\ de\ "\<poli\>", \ 
      seguir\[AAcute]\ siendo\ una\ funci\[OAcute]n, \ 
      las\ atribuciones\ hechas\ para\ x, \ y, \ 
      z\ pueden\ dar\ lugar\ a\ errores\ si\ no\ las\ limpias\ con\ un\ 
        Clear[] . \ Demasiado\ trabajo\ innecesario*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precauciones al usar el comando Random[ ]", "Section"],

Cell["\<\
Cuando queramos usar una misma salida del comando Random[ ] para hacer otras \
operaciones es obligado fijar por medio de una variable temporal la salida \
del comando Random[ ] para evitar que este se ejecute m\[AAcute]s de una vez. \
El siguiente ejemplo explica esto con claridad.\
\>", "Text"],

Cell["Ejemplo", "Example"],

Cell[TextData[{
  "La sucesi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`{\((1 + 1\/n)\)\^n}\)]],
  "converge al n\[UAcute]mero \[ExponentialE] (base de los logaritmos \
naturales o neperianos). Observa c\[OAcute]mo la aproximaci\[OAcute]n es cada \
vez mejor."
}], "Text"],

Cell[BoxData[
    \(Table[\[ExponentialE] - N[\((1 + 1\/k)\)\^k], {k, 100, 11200, 
        400}]\)], "Input"],

Cell[TextData[{
  "Observa lo que pasa ahora al elegir el entero ",
  StyleBox["k",
    FontSlant->"Italic"],
  " de forma aleatoria usando Random[Integer,",
  ".{100,11200}]."
}], "Text"],

Cell[BoxData[
    \(Table[\[ExponentialE] - 
        N[\((1 + 1\/Random[Integer, {100, 11200}])\)\^Random[Integer, {100, \
11200}]], {20}]\)], "Input"],

Cell[TextData[{
  "Lo que ocurre es que estamos ejecutando dos veces el comando ",
  "Random[Integer,",
  ".{100,11200}] y, claro est\[AAcute], el n\[UAcute]mero que elige cada vez \
no tiene por qu\[EAcute] ser el mismo, es decir, estamos obteniendo \
n\[UAcute]meros de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + 1\/n)\)\^m\)]],
  " donde ",
  StyleBox["n, m",
    FontSlant->"Italic"],
  " son enteros comprendidos entre 100 y 11200 pero, en general, ",
  StyleBox["n\[NotEqual]m",
    FontSlant->"Italic"],
  ". Eso puede solucionarse introduciendo una variable temporal que almacene \
el resultado de ejecutar una sola vez el comando ",
  "Random[Integer,",
  ".{100,11200}]."
}], "Text"],

Cell[BoxData[
    \(num := Random[Integer, {100, 11200}]; \n
    Table[\[ExponentialE] - N[\((1 + 1\/num)\)\^num], {10}]\)], "Input"],

Cell["\<\
\[DownExclamation]No hemos arreglado nada! Eso se debe a que estamos usando \
asignaci\[OAcute]n diferida y el comando Random[Integer,.{100,11200}] se \
ejecuta de nuevo cada vez que llamamos a \"num\". Usemos asignaci\[OAcute]n \
inmediata.\
\>", "Text"],

Cell[BoxData[
    \(num = Random[Integer, {100, 11200}]; \n
    Table[\[ExponentialE] - N[\((1 + 1\/num)\)\^num], {10}]\)], "Input"],

Cell[TextData[{
  "Ahora el comando ",
  "Random[Integer,",
  ".{100,11200}] se ha ejecutado una sola vez. No queremos tampoco eso. \
Queremos que el comando ",
  "Random[Integer,",
  ".{100,11200}] se ejecute cada vez y que el resultado se sustituya por ",
  StyleBox["n",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + 1\/n)\)\^n\)]],
  ". Puede hacerse poniendo en una misma lista las instrucciones apropiadas \
separadas por punto y coma. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solamente devolver\[AAcute] el resultado de la \[UAcute]ltima instrucci\
\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(Table[{n = Random[Integer, {100, 11200}]; 
        \[ExponentialE] - N[\((1 + 1\/n)\)\^n]}, {10}]\)], "Input"],

Cell[TextData[{
  "Esto ya es correcto. Un \[UAcute]ltimo detalle. Para obtener como salida \
una lista de n\[UAcute]meros (la salida anterior es una ",
  StyleBox["lista de listas",
    FontSlant->"Italic"],
  ") podemos hacerlo como sigue."
}], "Text"],

Cell[BoxData[
    RowBox[{"Table", "[", 
      RowBox[{
        RowBox[{
        \({n = Random[Integer, {100, 11200}]; 
            \[ExponentialE] - N[\((1 + 1\/n)\)\^n]}\), 
          StyleBox["[",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[\([1]\),
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox["]",
            FontColor->RGBColor[1, 0, 0]]}], ",", \({10}\)}], "]"}]], "Input"],

Cell["Y tambi\[EAcute]n.", "Text"],

Cell[BoxData[
    \(Table[{n = Random[Integer, {100, 11200}]; 
          \[ExponentialE] - N[\((1 + 1\/n)\)\^n]}, {10}] // Flatten\)], 
  "Input"],

Cell["\<\
El comando Random[ ] puede usarse para simular juegos de azar. Vamos a \
definir una urna con 8 objetos de distinta forma.\
\>", "Text"],

Cell[BoxData[
    \(\(urna = {\[FilledCircle], \[FilledSquare], \ \[FilledUpTriangle], \ 
        \[FilledDownTriangle], \ \[HappySmiley], \ \[NeutralSmiley], \ 
        \[SadSmiley], \ \[EmptySquare]}; \)\)], "Input"],

Cell[TextData[{
  "Naturalmente, para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"urna\" es una lista y puedes usar con ella los comandos antes vistos. "
}], "ExerciseText"],

Cell[BoxData[
    \({urna[\([4]\)], Take[urna, 3]}\)], "Input"],

Cell["\<\
La siguiente funci\[OAcute]n realiza al azar n extracciones (con \
reemplazamiento) en esta urna y devuelve los objetos obtenidos. \
\>", "ExerciseText"],

Cell[BoxData[{
    \(extracciones[n_] := Table[urna[\([Random[Integer, {1, 8}]]\)], {n}]\), 
    \(extracciones[20]\)}], "Input"],

Cell["\<\
Podemos contar las veces que aparece cada objeto en la lista anterior.\
\>", "Text"],

Cell[BoxData[
    \(Table[Count[%, urna[\([k]\)]], {k, 1, 8}]\)], "Input"],

Cell["\<\
Podemos ahora dividir estos resultados por el total de extracciones \
realizadas y as\[IAcute] obtenemos las frecuencias relativas con las que \
aparece cada elemento al realizar las extracciones.\
\>", "Text"],

Cell[BoxData[
    \(%/N[20]\)], "Input"],

Cell["\<\
Podemos convertir todo el proceso en una funci\[OAcute]n que calcule as \
frecuencias relativas en n extracciones.\
\>", "Text"],

Cell[BoxData[
    \(frecuenciasrelativas[n_] := {
        lista = Table[urna[\([Random[Integer, {1, 8}]]\)], {n}]; \ 
        Table[Count[lista, urna[\([k]\)]], {k, 1, 8}]/N[n]}\)], "Input"],

Cell[BoxData[
    \(\(frecuenciasrelativas[1000] (*se\ aproximan\ a\ 0.125, \ 
      como\ debe\ ser*) \)\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[TextData[{
  "Los ejercicios que siguen te servir\[AAcute]n para comprobar si ya eres \
capaz de realizar con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " algunas de las operaciones que hemos estudiado anteriormente."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"],
  ". "
}], "Exercise"],

Cell[TextData[{
  "a) Ordena de menor a mayor los n\[UAcute]meros \[Pi], ",
  Cell[BoxData[
      \(TraditionalForm\`1068966896\/340262731\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`103993\/33102\)]],
  ".\nb) \[DownQuestion]Qu\[EAcute] n\[UAcute]mero es menor ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\[Pi]\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^\[ExponentialE]\)]],
  "?\nc) Explica la respuesta de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " al comando N[N[Pi, 15], 30],"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Explica la respuesta de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". No olvides que es muy importante la forma en que se introducen los \
datos.\t"
}], "ExerciseText"],

Cell[BoxData[{
    \(f[x_] = Sum[Sin[n\ x], {n, 1, 2000}]; \n
    \(Timing[Table[f[x], {x, 1, 2, 1/100}]; ]\)[\([1]\)]\), 
    \(\(Timing[Table[f[x], {x, 1, 2, 0.01}]; ]\)[\([1]\)]\), 
    \(Clear[f]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula los l\[IAcute]mites de las siguientes funciones en ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  " (y si los aprendes de memoria, tanto mejor)."
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`\(x\  - \ sen\ x\)\/\(\(x\^3\)\(\ \)\), \ \(\(\ \)\(1 \
- cos\ x\)\)\/x\^2, \ \ \(\(\ \)\(tg\ x - x\)\)\/x\^3, \ \(\(\ \)\(log\ \((1 \
+ x)\) - x\)\)\/x\^2\)], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Define ",
  Cell[BoxData[
      \(TraditionalForm\`listauno = Range[2, 21], \ 
      listados = Range[22, 31]\)]],
  ". Realiza las siguientes operaciones usando algunos de los comandos antes \
vistos.\na) Multiplica cada elemento de \"listauno\" por todos los elementos \
de \"listados\". El resultado ser\[AAcute] una lista con 20 elementos (que a \
su vez ser\[AAcute]n listas de 10 elementos), a la que llamar\[AAcute]s \
\"productos\".\nb) Calcula la suma de cada una de las listas que forman la \
lista \"productos\" (no te equivoques, comprueba el resultado). Obtendr\
\[AAcute]s una lista con 20 n\[UAcute]meros.\nc) Calcula el producto de los \
elementos de la lista obtenida en el apartado anterior."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell["\<\
a) Genera una lista de 30 elementos cuyos elementos sean listas de dos n\
\[UAcute]meros.
b) Usando una regla de sustituci\[OAcute]n o una funci\[OAcute]n apropiada \
transforma la lista anterior en otra en la cual la primera coordenada de cada \
lista de dos elementos se ha multiplicado por 3 y la segunda coordenada se ha \
elevado al cuadrado.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Define una funci\[OAcute]n que al actuar sobre una lista num\[EAcute]rica \
la convierta en otra lista en la que cada n\[UAcute]mero ",
  StyleBox["a",
    FontSlant->"Italic"],
  " de la lista inicial ha sido reemplazado por {{",
  StyleBox["a",
    FontSlant->"Italic"],
  ",0},{",
  StyleBox["a",
    FontSlant->"Italic"],
  ", Cos[",
  StyleBox["a",
    FontSlant->"Italic"],
  "]}}."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell["\<\
Define una funci\[OAcute]n que deber\[AAcute]s evaluar sobre las siguientes \
listas.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(lista1 = Table[{{Random[]}, {Random[]}}, {15}]\), 
    \(lista2 = Table[{Random[], {{Random[]}}}, {10}]\)}], "Input"],

Cell["\<\
Dicha funci\[OAcute]n debe convertir un par de la forma {{x},{y}} o {x,{{y}}} \
en el par {x+y,x-y}.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell["\<\
Define una funci\[OAcute]n que selecciona en una lista de n\[UAcute]meros \
aquellos que son mayores que 2 o menores que -1. Comprueba tu funci\[OAcute]n \
con una lista adecuada.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "a) Calcula num\[EAcute]ricamente y simb\[OAcute]licamente la suma de todos \
los n\[UAcute]meros de la forma ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          FormBox[\(\((\(-1\))\)\^\(k + 1\)\),
            "TraditionalForm"], \(\@k\)], TraditionalForm]]],
  "desde k=1 hasta k=1000.\nb) Calcula num\[EAcute]ricamente y \
simb\[OAcute]licamente el producto de todos los n\[UAcute]meros de la forma ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((1 + 1\/k\^2)\)\)]],
  " desde k=1 hasta k=1000."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Explica lo que hace ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " al ejecutar los siguientes comandos en los que, aparentemente, una misma \
regla de sustituci\[OAcute]n parece actuar de forma distinta en cada caso."
}], "ExerciseText"],

Cell[BoxData[
    \({{1, 2}, {3, 4}, {5, 6}} /. {x_, y_} -> {x, 2\ y}\)], "Input"],

Cell[BoxData[
    \({{1, 2}, {3, 4}} /. {x_, y_} -> {x, 2\ y}\)], "Input"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Define una regla que al aplicarla sobre una lista de pares \
{{a,b},{c,d},{u,v},...} la convierta en {{a,2b},{c,2d},{u,2v},...}. Comprueba \
tu comando haci\[EAcute]ndolo trabajar sobre la lista {{a,b},{c,d}}."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Escribe una regla que cuando sea aplicada a una lista de ternas (puntos \
del espacio) {x,y,z} devuelva una lista de pares {x,y}. Comprueba dicha regla \
haci\[EAcute]ndola actuar sobre {{x,y,z},{a,b,c},{u,v,w}}."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{2, 3},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Entorno de trabajo. Aritm\[EAcute]tica. \nC\[AAcute]lculo simb\
\[OAcute]lico y aproximado. Operaciones boleanas. "], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Entorno de trabajo. Aritm\[EAcute]tica. \nC\[AAcute]lculo simb\
\[OAcute]lico y aproximado. Operaciones boleanas. "], "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 108, 4, 69, "Title"],
Cell[1820, 55, 203, 3, 72, "Author"],

Cell[CellGroupData[{
Cell[2048, 62, 39, 0, 69, "Section"],
Cell[2090, 64, 544, 8, 75, "Text"],
Cell[2637, 74, 1499, 27, 528, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4173, 106, 165, 5, 69, "Section"],
Cell[4341, 113, 2277, 44, 201, "Text"],
Cell[6621, 159, 1737, 37, 213, "Text"],
Cell[8361, 198, 116, 2, 76, "Input"],
Cell[8480, 202, 914, 19, 117, "Text"],
Cell[9397, 223, 464, 10, 54, "Text"],
Cell[9864, 235, 180, 3, 113, "Input"],
Cell[10047, 240, 123, 3, 33, "Text"],
Cell[10173, 245, 65, 1, 61, "Input"],
Cell[10241, 248, 356, 8, 54, "Text"],
Cell[10600, 258, 43, 1, 60, "Input"],
Cell[10646, 261, 237, 6, 33, "Text"],
Cell[10886, 269, 49, 1, 60, "Input"],
Cell[10938, 272, 1043, 33, 98, "Text"],
Cell[11984, 307, 34, 1, 60, "Input"],
Cell[12021, 310, 640, 16, 76, "Text"],
Cell[12664, 328, 457, 7, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13158, 340, 50, 0, 69, "Section"],
Cell[13211, 342, 681, 12, 96, "Text"],
Cell[13895, 356, 43, 1, 60, "Input"],
Cell[13941, 359, 183, 5, 33, "Text"],
Cell[14127, 366, 44, 1, 60, "Input"],
Cell[14174, 369, 161, 3, 33, "Text"],
Cell[14338, 374, 274, 6, 54, "Text"],
Cell[14615, 382, 42, 1, 73, "Input"],
Cell[14660, 385, 45, 1, 73, "Input"],
Cell[14708, 388, 86, 2, 33, "Text"],
Cell[14797, 392, 44, 1, 73, "Input"],
Cell[14844, 395, 186, 5, 33, "Text"],
Cell[15033, 402, 37, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15107, 408, 48, 0, 69, "Section"],
Cell[15158, 410, 618, 15, 76, "Text"],
Cell[15779, 427, 456, 11, 54, "Text"],
Cell[16238, 440, 67, 1, 60, "Input"],
Cell[16308, 443, 214, 6, 33, "Text"],
Cell[16525, 451, 53, 1, 60, "Input"],
Cell[16581, 454, 544, 12, 75, "Text"],
Cell[17128, 468, 55, 1, 60, "Input"],
Cell[17186, 471, 1042, 26, 96, "Text"],
Cell[18231, 499, 72, 1, 60, "Input"],
Cell[18306, 502, 1997, 45, 215, "Text"],
Cell[20306, 549, 50, 1, 60, "Input"],
Cell[20359, 552, 419, 11, 55, "Text"],
Cell[20781, 565, 120, 4, 123, "Input"],
Cell[20904, 571, 1152, 39, 100, "Text"],
Cell[22059, 612, 1241, 25, 386, "Input"],
Cell[23303, 639, 365, 6, 75, "Text"],
Cell[23671, 647, 769, 18, 98, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24477, 670, 39, 0, 69, "Section"],
Cell[24519, 672, 1373, 21, 249, "Text"],
Cell[25895, 695, 166, 5, 148, "Input"],
Cell[26064, 702, 194, 6, 33, "Text"],
Cell[26261, 710, 215, 4, 81, "Input"],
Cell[26479, 716, 2468, 57, 246, "Text"],
Cell[28950, 775, 222, 4, 81, "Input"],
Cell[29175, 781, 239, 4, 81, "Input"],
Cell[29417, 787, 235, 4, 81, "Input"],
Cell[29655, 793, 204, 3, 81, "Input"],
Cell[29862, 798, 218, 4, 81, "Input"],
Cell[30083, 804, 169, 3, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30289, 812, 116, 5, 69, "Section"],
Cell[30408, 819, 386, 8, 54, "Text"],
Cell[30797, 829, 50, 1, 33, "Text"],
Cell[30850, 832, 279, 5, 54, "Text"],
Cell[31132, 839, 41, 1, 60, "Input"],
Cell[31176, 842, 94, 1, 33, "Text"],
Cell[31273, 845, 39, 1, 60, "Input"],
Cell[31315, 848, 117, 3, 33, "Text"],
Cell[31435, 853, 42, 1, 60, "Input"],
Cell[31480, 856, 116, 3, 33, "Text"],
Cell[31599, 861, 43, 1, 60, "Input"],
Cell[31645, 864, 283, 11, 34, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31965, 880, 138, 5, 69, "Section"],
Cell[32106, 887, 1630, 31, 265, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33773, 923, 150, 5, 69, "Section"],
Cell[33926, 930, 440, 11, 55, "Text"],
Cell[34369, 943, 137, 3, 102, "Input"],
Cell[34509, 948, 801, 15, 96, "Text"],
Cell[35313, 965, 1912, 59, 143, "Text"],
Cell[37228, 1026, 57, 2, 81, "Input"],
Cell[37288, 1030, 110, 3, 33, "Text"],
Cell[37401, 1035, 37, 1, 60, "Input"],
Cell[37441, 1038, 112, 3, 33, "Text"],
Cell[37556, 1043, 56, 2, 81, "Input"],
Cell[37615, 1047, 174, 6, 33, "Text"],
Cell[37792, 1055, 45, 1, 60, "Input"],
Cell[37840, 1058, 42, 1, 60, "Input"],
Cell[37885, 1061, 164, 5, 34, "Text"],
Cell[38052, 1068, 122, 3, 60, "Input"],
Cell[38177, 1073, 39, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38253, 1079, 136, 5, 69, "Section"],
Cell[38392, 1086, 1493, 51, 121, "Text"],
Cell[39888, 1139, 81, 3, 102, "Input"],
Cell[39972, 1144, 246, 4, 54, "Text"],
Cell[40221, 1150, 54, 1, 60, "Input"],
Cell[40278, 1153, 43, 1, 60, "Input"],
Cell[40324, 1156, 407, 7, 75, "Text"],
Cell[40734, 1165, 55, 1, 60, "Input"],
Cell[40792, 1168, 66, 2, 81, "Input"],
Cell[40861, 1172, 549, 13, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41447, 1190, 28, 0, 69, "Section"],
Cell[41478, 1192, 1186, 29, 120, "Text"],
Cell[42667, 1223, 281, 7, 60, "Input"],
Cell[42951, 1232, 185, 4, 33, "Text"],
Cell[43139, 1238, 69, 3, 102, "Input"],
Cell[43211, 1243, 1102, 26, 119, "Text"],
Cell[44316, 1271, 135, 3, 81, "Input"],
Cell[44454, 1276, 69, 3, 102, "Input"],
Cell[44526, 1281, 236, 8, 34, "Text"],
Cell[44765, 1291, 69, 2, 86, "Input"],
Cell[44837, 1295, 139, 3, 33, "Text"],
Cell[44979, 1300, 238, 6, 127, "Input"],
Cell[45220, 1308, 295, 5, 54, "Text"],
Cell[45518, 1315, 169, 4, 81, "Input"],
Cell[45690, 1321, 455, 11, 54, "Text"],
Cell[46148, 1334, 87, 3, 102, "Input"],
Cell[46238, 1339, 181, 4, 33, "Text"],
Cell[46422, 1345, 261, 5, 54, "Text"],
Cell[46686, 1352, 716, 22, 78, "Text"],
Cell[47405, 1376, 259, 7, 55, "Text"],
Cell[47667, 1385, 68, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47772, 1391, 42, 0, 69, "Section"],
Cell[47817, 1393, 954, 25, 99, "Text"],
Cell[48774, 1420, 205, 5, 144, "Input"],
Cell[48982, 1427, 29, 0, 33, "Text"],
Cell[49014, 1429, 360, 7, 165, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49411, 1441, 75, 0, 69, "Section"],
Cell[49489, 1443, 117, 3, 33, "Text"],
Cell[49609, 1448, 117, 2, 60, "Input"],
Cell[49729, 1452, 109, 3, 33, "Text"],
Cell[49841, 1457, 45, 1, 60, "Input"],
Cell[49889, 1460, 204, 8, 34, "Text"],
Cell[50096, 1470, 109, 2, 60, "Input"],
Cell[50208, 1474, 42, 1, 60, "Input"],
Cell[50253, 1477, 178, 3, 81, "Input"],
Cell[50434, 1482, 102, 2, 60, "Input"],
Cell[50539, 1486, 176, 3, 81, "Input"],
Cell[50718, 1491, 279, 7, 55, "Text"],
Cell[51000, 1500, 72, 1, 60, "Input"],
Cell[51075, 1503, 72, 1, 60, "Input"],
Cell[51150, 1506, 231, 5, 34, "Text"],
Cell[51384, 1513, 142, 3, 60, "Input"],
Cell[51529, 1518, 167, 3, 60, "Input"],
Cell[51699, 1523, 108, 3, 33, "Text"],
Cell[51810, 1528, 206, 4, 113, "Input"],
Cell[52019, 1534, 166, 2, 74, "Input"],
Cell[52188, 1538, 152, 2, 77, "Input"],
Cell[52343, 1542, 126, 2, 77, "Input"],
Cell[52472, 1546, 164, 3, 77, "Input"],
Cell[52639, 1551, 149, 3, 77, "Input"],
Cell[52791, 1556, 754, 15, 96, "Text"],
Cell[53548, 1573, 55, 1, 60, "Input"],
Cell[53606, 1576, 62, 1, 60, "Input"],
Cell[53671, 1579, 162, 3, 60, "Input"],
Cell[53836, 1584, 46, 1, 60, "Input"],
Cell[53885, 1587, 446, 14, 33, "Text"],
Cell[54334, 1603, 241, 5, 81, "Input"],
Cell[54578, 1610, 219, 4, 60, "Input"],
Cell[54800, 1616, 197, 3, 60, "Input"],
Cell[55000, 1621, 354, 7, 54, "Text"],
Cell[55357, 1630, 58, 1, 60, "Input"],
Cell[55418, 1633, 663, 24, 54, "Text"],
Cell[56084, 1659, 180, 3, 81, "Input"],
Cell[56267, 1664, 227, 4, 60, "Input"],
Cell[56497, 1670, 190, 3, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[56724, 1678, 25, 0, 69, "Section"],
Cell[56752, 1680, 413, 9, 75, "Text"],
Cell[57168, 1691, 83, 1, 60, "Input"],
Cell[57254, 1694, 116, 3, 33, "Text"],
Cell[57373, 1699, 996, 18, 285, "Text"],
Cell[58372, 1719, 431, 12, 249, "Input"],
Cell[58806, 1733, 154, 3, 33, "Text"],
Cell[58963, 1738, 356, 6, 123, "Input"],
Cell[59322, 1746, 461, 15, 55, "Text"],
Cell[59786, 1763, 145, 4, 123, "Input"],
Cell[59934, 1769, 107, 3, 33, "Text"],
Cell[60044, 1774, 158, 2, 81, "Input"],
Cell[60205, 1778, 144, 3, 33, "Text"],
Cell[60352, 1783, 137, 2, 60, "Input"],
Cell[60492, 1787, 280, 4, 54, "Text"],
Cell[60775, 1793, 290, 5, 102, "Input"],
Cell[61068, 1800, 182, 4, 33, "Text"],
Cell[61253, 1806, 70, 1, 60, "Input"],
Cell[61326, 1809, 42, 1, 60, "Input"],
Cell[61371, 1812, 38, 0, 33, "Text"],
Cell[61412, 1814, 262, 5, 123, "Input"],
Cell[61677, 1821, 97, 2, 33, "Text"],
Cell[61777, 1825, 57, 1, 60, "Input"],
Cell[61837, 1828, 177, 3, 33, "Text"],
Cell[62017, 1833, 45, 1, 60, "Input"],
Cell[62065, 1836, 48, 1, 60, "Input"],
Cell[62116, 1839, 78, 1, 60, "Input"],
Cell[62197, 1842, 285, 5, 54, "Text"],
Cell[62485, 1849, 483, 9, 165, "Input"],
Cell[62971, 1860, 146, 3, 33, "Text"],
Cell[63120, 1865, 160, 4, 123, "Input"],
Cell[63283, 1871, 143, 3, 33, "Text"],
Cell[63429, 1876, 365, 7, 123, "Input"],
Cell[63797, 1885, 372, 7, 123, "Input"],
Cell[64172, 1894, 158, 3, 33, "Text"],
Cell[64333, 1899, 83, 1, 60, "Input"],
Cell[64419, 1902, 325, 7, 54, "Text"],
Cell[64747, 1911, 66, 1, 60, "Input"],
Cell[64816, 1914, 66, 1, 60, "Input"],
Cell[64885, 1917, 45, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64967, 1923, 109, 3, 69, "Section"],
Cell[65079, 1928, 315, 7, 54, "Text"],
Cell[65397, 1937, 204, 5, 144, "Input"],
Cell[65604, 1944, 608, 11, 75, "Text"],
Cell[66215, 1957, 153, 3, 81, "Input"],
Cell[66371, 1962, 446, 7, 75, "Text"],
Cell[66820, 1971, 361, 7, 144, "Input"],
Cell[67184, 1980, 173, 3, 33, "Text"],
Cell[67360, 1985, 420, 8, 123, "Input"],
Cell[67783, 1995, 147, 3, 33, "Text"],
Cell[67933, 2000, 143, 3, 123, "Input"],
Cell[68079, 2005, 241, 6, 33, "Text"],
Cell[68323, 2013, 143, 2, 81, "Input"],
Cell[68469, 2017, 309, 7, 56, "Text"],
Cell[68781, 2026, 124, 2, 102, "Input"],
Cell[68908, 2030, 163, 3, 33, "Text"],
Cell[69074, 2035, 178, 4, 123, "Input"],
Cell[69255, 2041, 376, 8, 55, "Text"],
Cell[69634, 2051, 277, 5, 144, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69948, 2061, 75, 0, 69, "Section"],
Cell[70026, 2063, 123, 3, 33, "Text"],
Cell[70152, 2068, 269, 4, 102, "Input"],
Cell[70424, 2074, 219, 4, 54, "Text"],
Cell[70646, 2080, 46, 1, 60, "Input"],
Cell[70695, 2083, 621, 12, 76, "Text"],
Cell[71319, 2097, 217, 4, 81, "Input"],
Cell[71539, 2103, 270, 5, 81, "Input"],
Cell[71812, 2110, 180, 4, 33, "Text"],
Cell[71995, 2116, 432, 8, 144, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72464, 2129, 56, 0, 69, "Section"],
Cell[72523, 2131, 490, 10, 75, "Text"],
Cell[73016, 2143, 108, 2, 81, "Input"],
Cell[73127, 2147, 260, 5, 54, "Text"],
Cell[73390, 2154, 79, 1, 60, "Input"],
Cell[73472, 2157, 315, 5, 54, "Text"],
Cell[73790, 2164, 77, 1, 60, "Input"],
Cell[73870, 2167, 243, 4, 54, "Text"],
Cell[74116, 2173, 90, 1, 60, "Input"],
Cell[74209, 2176, 198, 4, 33, "Text"],
Cell[74410, 2182, 81, 1, 81, "Input"],
Cell[74494, 2185, 100, 2, 81, "Input"],
Cell[74597, 2189, 316, 7, 54, "Text"],
Cell[74916, 2198, 363, 7, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75316, 2210, 83, 1, 69, "Section"],
Cell[75402, 2213, 320, 5, 54, "Text"],
Cell[75725, 2220, 188, 3, 81, "Input"],
Cell[75916, 2225, 138, 3, 33, "Text"],
Cell[76057, 2230, 69, 2, 81, "Input"],
Cell[76129, 2234, 2160, 71, 165, "Text"],
Cell[78292, 2307, 378, 6, 144, "Input"],
Cell[78673, 2315, 84, 1, 60, "Input"],
Cell[78760, 2318, 325, 11, 34, "Text"],
Cell[79088, 2331, 56, 1, 60, "Input"],
Cell[79147, 2334, 272, 7, 54, "Text"],
Cell[79422, 2343, 104, 2, 60, "Input"],
Cell[79529, 2347, 261, 5, 54, "Text"],
Cell[79793, 2354, 108, 2, 60, "Input"],
Cell[79904, 2358, 167, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[80096, 2365, 82, 1, 60, "Input"],
Cell[80181, 2368, 84, 1, 60, "Output"]
}, Open  ]],
Cell[80280, 2372, 225, 6, 33, "Text"],
Cell[80508, 2380, 90, 1, 60, "Input"],
Cell[80601, 2383, 230, 6, 33, "Text"],
Cell[80834, 2391, 837, 26, 77, "Text"],
Cell[81674, 2419, 215, 3, 102, "Input"],
Cell[81892, 2424, 297, 4, 102, "Input"],
Cell[82192, 2430, 2940, 93, 120, "Text"],
Cell[85135, 2525, 217, 4, 117, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85389, 2534, 44, 0, 69, "Section"],
Cell[85436, 2536, 899, 23, 97, "Text"],
Cell[86338, 2561, 293, 6, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86668, 2572, 59, 0, 69, "Section"],
Cell[86730, 2574, 620, 11, 96, "Text"],
Cell[87353, 2587, 1419, 23, 292, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88809, 2615, 60, 0, 69, "Section"],
Cell[88872, 2617, 307, 5, 54, "Text"],
Cell[89182, 2624, 26, 0, 42, "Example"],
Cell[89211, 2626, 283, 7, 36, "Text"],
Cell[89497, 2635, 109, 2, 74, "Input"],
Cell[89609, 2639, 188, 6, 33, "Text"],
Cell[89800, 2647, 151, 3, 77, "Input"],
Cell[89954, 2652, 710, 18, 78, "Text"],
Cell[90667, 2672, 133, 2, 96, "Input"],
Cell[90803, 2676, 265, 5, 54, "Text"],
Cell[91071, 2683, 132, 2, 96, "Input"],
Cell[91206, 2687, 636, 18, 78, "Text"],
Cell[91845, 2707, 130, 2, 73, "Input"],
Cell[91978, 2711, 254, 6, 33, "Text"],
Cell[92235, 2719, 418, 11, 73, "Input"],
Cell[92656, 2732, 34, 0, 33, "Text"],
Cell[92693, 2734, 146, 3, 73, "Input"],
Cell[92842, 2739, 146, 3, 33, "Text"],
Cell[92991, 2744, 218, 3, 60, "Input"],
Cell[93212, 2749, 190, 5, 33, "ExerciseText"],
Cell[93405, 2756, 63, 1, 60, "Input"],
Cell[93471, 2759, 163, 3, 33, "ExerciseText"],
Cell[93637, 2764, 129, 2, 81, "Input"],
Cell[93769, 2768, 94, 2, 33, "Text"],
Cell[93866, 2772, 74, 1, 60, "Input"],
Cell[93943, 2775, 220, 4, 54, "Text"],
Cell[94166, 2781, 40, 1, 60, "Input"],
Cell[94209, 2784, 138, 3, 33, "Text"],
Cell[94350, 2789, 190, 3, 81, "Input"],
Cell[94543, 2794, 118, 2, 60, "Input"],
Cell[94664, 2798, 54, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[94755, 2804, 34, 0, 67, "ExerciseMain"],
Cell[94792, 2806, 248, 6, 54, "Text"],

Cell[CellGroupData[{
Cell[95065, 2816, 89, 4, 48, "Exercise"],
Cell[95157, 2822, 564, 17, 94, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95758, 2844, 31, 0, 48, "Exercise"],
Cell[95792, 2846, 201, 6, 33, "ExerciseText"],
Cell[95996, 2854, 213, 4, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[96246, 2863, 31, 0, 48, "Exercise"],
Cell[96280, 2865, 202, 5, 33, "ExerciseText"],
Cell[96485, 2872, 229, 4, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[96751, 2881, 31, 0, 48, "Exercise"],
Cell[96785, 2883, 749, 13, 162, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97571, 2901, 31, 0, 48, "Exercise"],
Cell[97605, 2903, 379, 7, 83, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98021, 2915, 31, 0, 48, "Exercise"],
Cell[98055, 2917, 427, 15, 54, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98519, 2937, 31, 0, 48, "Exercise"],
Cell[98553, 2939, 117, 3, 33, "ExerciseText"],
Cell[98673, 2944, 138, 2, 81, "Input"],
Cell[98814, 2948, 132, 3, 33, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98983, 2956, 31, 0, 48, "Exercise"],
Cell[99017, 2958, 211, 4, 54, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99265, 2967, 31, 0, 48, "Exercise"],
Cell[99299, 2969, 551, 14, 74, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99887, 2988, 32, 0, 48, "Exercise"],
Cell[99922, 2990, 311, 8, 55, "ExerciseText"],
Cell[100236, 3000, 82, 1, 60, "Input"],
Cell[100321, 3003, 74, 1, 60, "Input"],
Cell[100398, 3006, 292, 6, 55, "ExerciseText"],
Cell[100693, 3014, 295, 6, 55, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

